/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CommitLog;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.AbstractColumnIterator;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.DestructivePQIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class Memtable
implements Comparable<Memtable> {
    private static Logger logger_ = Logger.getLogger(Memtable.class);
    private boolean isFrozen_;
    private volatile boolean isDirty_;
    private volatile boolean isFlushed_;
    private int threshold_ = DatabaseDescriptor.getMemtableSize() * 1024 * 1024;
    private int thresholdCount_ = (int)(DatabaseDescriptor.getMemtableObjectCount() * 1024.0 * 1024.0);
    private AtomicInteger currentSize_ = new AtomicInteger(0);
    private AtomicInteger currentObjectCount_ = new AtomicInteger(0);
    private String table_;
    private String cfName_;
    private long creationTime_;
    private Map<String, ColumnFamily> columnFamilies_ = new HashMap<String, ColumnFamily>();

    Memtable(String table, String cfName) {
        this.table_ = table;
        this.cfName_ = cfName;
        this.creationTime_ = System.currentTimeMillis();
    }

    public boolean isFlushed() {
        return this.isFlushed_;
    }

    @Override
    public int compareTo(Memtable rhs) {
        long diff = this.creationTime_ - rhs.creationTime_;
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    public int getCurrentSize() {
        return this.currentSize_.get();
    }

    public int getCurrentObjectCount() {
        return this.currentObjectCount_.get();
    }

    void resolveSize(int oldSize, int newSize) {
        this.currentSize_.addAndGet(newSize - oldSize);
    }

    void resolveCount(int oldCount, int newCount) {
        this.currentObjectCount_.addAndGet(newCount - oldCount);
    }

    boolean isThresholdViolated() {
        return this.currentSize_.get() >= this.threshold_ || this.currentObjectCount_.get() >= this.thresholdCount_;
    }

    String getColumnFamily() {
        return this.cfName_;
    }

    boolean isFrozen() {
        return this.isFrozen_;
    }

    void freeze() {
        this.isFrozen_ = true;
    }

    void put(String key, ColumnFamily columnFamily) {
        assert (!this.isFrozen_);
        this.isDirty_ = true;
        this.resolve(key, columnFamily);
    }

    void flushOnRecovery() throws IOException {
        if (!this.isClean()) {
            this.flush(CommitLog.CommitLogContext.NULL);
        }
    }

    private void resolve(String key, ColumnFamily columnFamily) {
        ColumnFamily oldCf = this.columnFamilies_.get(key);
        if (oldCf != null) {
            int oldSize = oldCf.size();
            int oldObjectCount = oldCf.getColumnCount();
            oldCf.addColumns(columnFamily);
            int newSize = oldCf.size();
            int newObjectCount = oldCf.getColumnCount();
            this.resolveSize(oldSize, newSize);
            this.resolveCount(oldObjectCount, newObjectCount);
            oldCf.delete(columnFamily);
        } else {
            this.columnFamilies_.put(key, columnFamily);
            this.currentSize_.addAndGet(columnFamily.size() + key.length());
            this.currentObjectCount_.addAndGet(columnFamily.getColumnCount());
        }
    }

    public String contents() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Map.Entry<String, ColumnFamily> entry : this.columnFamilies_.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    void flush(CommitLog.CommitLogContext cLogCtx) throws IOException {
        logger_.info((Object)("Flushing " + this));
        ColumnFamilyStore cfStore = Table.open(this.table_).getColumnFamilyStore(this.cfName_);
        SSTableWriter writer = new SSTableWriter(cfStore.getTempSSTablePath(), this.columnFamilies_.size(), StorageService.getPartitioner());
        final IPartitioner partitioner = StorageService.getPartitioner();
        final Comparator<String> dc = partitioner.getDecoratedKeyComparator();
        ArrayList<String> orderedKeys = new ArrayList<String>(this.columnFamilies_.keySet());
        Collections.sort(orderedKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return dc.compare(partitioner.decorateKey(o1), partitioner.decorateKey(o2));
            }
        });
        DataOutputBuffer buffer = new DataOutputBuffer();
        for (String key : orderedKeys) {
            buffer.reset();
            ColumnFamily columnFamily = this.columnFamilies_.get(key);
            if (columnFamily == null) continue;
            ColumnFamily.serializer().serializeWithIndexes(columnFamily, buffer);
            writer.append(partitioner.decorateKey(key), buffer);
        }
        SSTableReader ssTable = writer.closeAndOpenReader();
        cfStore.onMemtableFlush(cLogCtx);
        cfStore.storeLocation(ssTable);
        buffer.close();
        this.isFlushed_ = true;
        logger_.info((Object)("Completed flushing " + ssTable.getFilename()));
    }

    public String toString() {
        return "Memtable(" + this.cfName_ + ")@" + this.hashCode();
    }

    Set<String> getKeys() throws ExecutionException, InterruptedException {
        return new HashSet<String>(this.columnFamilies_.keySet());
    }

    public static Iterator<String> getKeyIterator(Set<String> keys) {
        if (keys.size() == 0) {
            return Arrays.asList(new String[0]).iterator();
        }
        PriorityQueue<String> pq = new PriorityQueue<String>(keys.size(), StorageService.getPartitioner().getDecoratedKeyComparator());
        pq.addAll(keys);
        return new DestructivePQIterator<String>(pq);
    }

    public boolean isClean() {
        return !this.isDirty_;
    }

    public ColumnIterator getSliceIterator(SliceQueryFilter filter, AbstractType typeComparator) {
        ColumnFamily cf = this.columnFamilies_.get(filter.key);
        final ColumnFamily columnFamily = cf == null ? ColumnFamily.create(this.table_, filter.getColumnFamilyName()) : cf.cloneMeShallow();
        Object[] columns = (cf == null ? columnFamily : cf).getSortedColumns().toArray(new IColumn[columnFamily.getSortedColumns().size()]);
        if (filter.reversed) {
            ArrayUtils.reverse((Object[])columns);
        }
        IColumn startIColumn = DatabaseDescriptor.getColumnFamilyType(this.table_, filter.getColumnFamilyName()).equals("Standard") ? new Column(filter.start) : new SuperColumn(filter.start, null);
        Comparator<IColumn> comparator = filter.getColumnComparator(typeComparator);
        int index = filter.start.length == 0 && filter.reversed ? 0 : Arrays.binarySearch(columns, startIColumn, comparator);
        final int startIndex = index < 0 ? -(index + 1) : index;
        return new AbstractColumnIterator((IColumn[])columns){
            private int curIndex_;
            final /* synthetic */ IColumn[] val$columns;
            {
                this.val$columns = iColumnArray;
                this.curIndex_ = startIndex;
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return columnFamily;
            }

            @Override
            public boolean hasNext() {
                return this.curIndex_ < this.val$columns.length;
            }

            @Override
            public IColumn next() {
                return this.val$columns[this.curIndex_++];
            }
        };
    }

    public ColumnIterator getNamesIterator(final NamesQueryFilter filter) {
        final ColumnFamily cf = this.columnFamilies_.get(filter.key);
        final ColumnFamily columnFamily = cf == null ? ColumnFamily.create(this.table_, filter.getColumnFamilyName()) : cf.cloneMeShallow();
        return new SimpleAbstractColumnIterator(){
            private Iterator<byte[]> iter;
            private byte[] current;
            {
                this.iter = filter.columns.iterator();
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return columnFamily;
            }

            protected IColumn computeNext() {
                if (cf == null) {
                    return (IColumn)this.endOfData();
                }
                while (this.iter.hasNext()) {
                    this.current = this.iter.next();
                    IColumn column = cf.getColumn(this.current);
                    if (column == null) continue;
                    return column;
                }
                return (IColumn)this.endOfData();
            }
        };
    }

    void clearUnsafe() {
        this.columnFamilies_.clear();
    }
}

