/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CheaterFutureTask;
import org.apache.cassandra.db.CommitLog;
import org.apache.cassandra.db.CommitLogExecutorServiceMBean;

public class CommitLogExecutorService
extends AbstractExecutorService
implements CommitLogExecutorServiceMBean {
    BlockingQueue<CheaterFutureTask> queue;
    private ArrayList<CheaterFutureTask> incompleteTasks = new ArrayList();
    private ArrayList taskValues = new ArrayList();

    public CommitLogExecutorService() {
        this.queue = new ArrayBlockingQueue<CheaterFutureTask>(10000);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DatabaseDescriptor.getCommitLogSync() == DatabaseDescriptor.CommitLogSync.batch) {
                        while (true) {
                            CommitLogExecutorService.this.processWithSyncBatch();
                        }
                    }
                    while (true) {
                        CommitLogExecutorService.this.process();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        new Thread(runnable, "COMMIT-LOG-WRITER").start();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.concurrent:type=COMMITLOG"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getPendingTasks() {
        return this.queue.size();
    }

    private void process() throws InterruptedException {
        this.queue.take().run();
    }

    private void processWithSyncBatch() throws Exception {
        CheaterFutureTask firstTask = this.queue.take();
        if (!(firstTask.getRawCallable() instanceof CommitLog.LogRecordAdder)) {
            firstTask.run();
            return;
        }
        this.incompleteTasks.clear();
        this.taskValues.clear();
        long end = System.nanoTime() + (long)(1000000.0 * DatabaseDescriptor.getCommitLogSyncBatchWindow());
        this.incompleteTasks.add(firstTask);
        this.taskValues.add(firstTask.getRawCallable().call());
        while (!this.queue.isEmpty() && ((CheaterFutureTask)this.queue.peek()).getRawCallable() instanceof CommitLog.LogRecordAdder && System.nanoTime() < end) {
            CheaterFutureTask task = (CheaterFutureTask)this.queue.remove();
            this.incompleteTasks.add(task);
            this.taskValues.add(task.getRawCallable().call());
        }
        try {
            CommitLog.open().sync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < this.incompleteTasks.size(); ++i) {
            this.incompleteTasks.get(i).set(this.taskValues.get(i));
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new CheaterFutureTask<T>(callable);
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.queue.put((CheaterFutureTask)command);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

