/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CommitLogExecutorService;
import org.apache.cassandra.db.CommitLogHeader;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.io.BufferedRandomAccessFile;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CommitLog {
    private static volatile int SEGMENT_SIZE = 0x8000000;
    private static volatile CommitLog instance_;
    private static Lock lock_;
    private static Logger logger_;
    private static Map<String, CommitLogHeader> clHeaders_;
    private ExecutorService executor;
    private String logFile_;
    private CommitLogHeader clHeader_;
    private BufferedRandomAccessFile logWriter_;

    public static void setSegmentSize(int size) {
        SEGMENT_SIZE = size;
    }

    static int getSegmentCount() {
        return clHeaders_.size();
    }

    static long getCreationTime(String file) {
        String[] entries = FBUtilities.strip(file, "-.");
        return Long.parseLong(entries[entries.length - 2]);
    }

    private static BufferedRandomAccessFile createWriter(String file) throws IOException {
        return new BufferedRandomAccessFile(file, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CommitLog open() throws IOException {
        if (instance_ == null) {
            lock_.lock();
            try {
                if (instance_ == null) {
                    instance_ = new CommitLog(false);
                }
            }
            finally {
                lock_.unlock();
            }
        }
        return instance_;
    }

    private void setNextFileName() {
        this.logFile_ = DatabaseDescriptor.getLogFileLocation() + File.separator + "CommitLog-" + System.currentTimeMillis() + ".log";
    }

    CommitLog(boolean recoveryMode) throws IOException {
        if (!recoveryMode) {
            this.executor = new CommitLogExecutorService();
            this.setNextFileName();
            this.logWriter_ = CommitLog.createWriter(this.logFile_);
            this.writeCommitLogHeader();
            if (DatabaseDescriptor.getCommitLogSync() == DatabaseDescriptor.CommitLogSync.periodic) {
                final Runnable syncer = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CommitLog.this.sync();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            CommitLog.this.executor.submit(syncer);
                            try {
                                Thread.sleep(DatabaseDescriptor.getCommitLogSyncPeriod());
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }, "PERIODIC-COMMIT-LOG-SYNCER").start();
            }
        }
    }

    CommitLog(File logFile) throws IOException {
        this.logFile_ = logFile.getAbsolutePath();
        this.logWriter_ = CommitLog.createWriter(this.logFile_);
    }

    String getLogFile() {
        return this.logFile_;
    }

    private CommitLogHeader readCommitLogHeader(BufferedRandomAccessFile logReader) throws IOException {
        int size = (int)logReader.readLong();
        byte[] bytes = new byte[size];
        logReader.read(bytes);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        return CommitLogHeader.serializer().deserialize(new DataInputStream(byteStream));
    }

    private void writeCommitLogHeader() throws IOException {
        int cfSize = Table.TableMetadata.getColumnFamilyCount();
        this.clHeader_ = new CommitLogHeader(cfSize);
        CommitLog.writeCommitLogHeader(this.logWriter_, this.clHeader_.toByteArray());
    }

    private void seekAndWriteCommitLogHeader(byte[] bytes) throws IOException {
        long currentPos = this.logWriter_.getFilePointer();
        this.logWriter_.seek(0L);
        CommitLog.writeCommitLogHeader(this.logWriter_, bytes);
        this.logWriter_.seek(currentPos);
    }

    private static void writeCommitLogHeader(RandomAccessFile logWriter, byte[] bytes) throws IOException {
        logWriter.writeLong(bytes.length);
        logWriter.write(bytes);
    }

    void recover(File[] clogs) throws IOException {
        DataInputBuffer bufIn = new DataInputBuffer();
        for (File file : clogs) {
            int bufferSize = (int)Math.min(file.length(), 0x2000000L);
            BufferedRandomAccessFile reader = new BufferedRandomAccessFile(file.getAbsolutePath(), "r", bufferSize);
            CommitLogHeader clHeader = this.readCommitLogHeader(reader);
            int lowPos = CommitLogHeader.getLowestPosition(clHeader);
            if (lowPos == 0) break;
            reader.seek(lowPos);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Replaying " + file + " starting at " + lowPos));
            }
            HashSet<Table> tablesRecovered = new HashSet<Table>();
            while (!reader.isEOF()) {
                byte[] bytes;
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Reading mutation at " + reader.getFilePointer()));
                }
                try {
                    bytes = new byte[(int)reader.readLong()];
                    if (reader.read(bytes) < bytes.length) {
                        throw new EOFException();
                    }
                }
                catch (EOFException e) {
                    break;
                }
                bufIn.reset(bytes, bytes.length);
                Row row = Row.serializer().deserialize(bufIn);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)String.format("replaying mutation for %s.%s: %s", row.getTable(), row.key(), "{" + StringUtils.join(row.getColumnFamilies(), (String)", ") + "}"));
                }
                Table table = Table.open(row.getTable());
                tablesRecovered.add(table);
                ArrayList<ColumnFamily> columnFamilies = new ArrayList<ColumnFamily>(row.getColumnFamilies());
                for (ColumnFamily columnFamily : columnFamilies) {
                    int id = table.getColumnFamilyId(columnFamily.name());
                    if (clHeader.isDirty(id) && reader.getFilePointer() >= (long)clHeader.getPosition(id)) continue;
                    row.removeColumnFamily(columnFamily);
                }
                if (row.isEmpty()) continue;
                table.applyNow(row);
            }
            reader.close();
            for (Table table : tablesRecovered) {
                table.flush(true);
            }
        }
    }

    private void maybeUpdateHeader(Row row) throws IOException {
        Table table = Table.open(row.getTable());
        for (ColumnFamily columnFamily : row.getColumnFamilies()) {
            int id = table.getColumnFamilyId(columnFamily.name());
            if (this.clHeader_.isDirty(id)) continue;
            this.clHeader_.turnOn(id, this.logWriter_.getFilePointer());
            this.seekAndWriteCommitLogHeader(this.clHeader_.toByteArray());
        }
    }

    CommitLogContext getContext() throws IOException {
        Callable<CommitLogContext> task = new Callable<CommitLogContext>(){

            @Override
            public CommitLogContext call() throws Exception {
                return new CommitLogContext(CommitLog.this.logFile_, CommitLog.this.logWriter_.getFilePointer());
            }
        };
        try {
            return this.executor.submit(task).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    CommitLogContext add(Row row) throws IOException {
        LogRecordAdder task = new LogRecordAdder(row);
        try {
            return this.executor.submit(task).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    void onMemtableFlush(final String tableName, final String cf, final CommitLogContext cLogCtx) throws IOException {
        Callable task = new Callable(){

            public Object call() throws IOException {
                Table table = Table.open(tableName);
                int id = table.getColumnFamilyId(cf);
                CommitLog.this.discardCompletedSegments(cLogCtx, id);
                return null;
            }
        };
        try {
            this.executor.submit(task).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void discardCompletedSegments(CommitLogContext cLogCtx, int id) throws IOException {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("discard completed log segments for " + cLogCtx + ", column family " + id + ". CFIDs are " + Table.TableMetadata.getColumnFamilyIDString()));
        }
        if (clHeaders_.get(cLogCtx.file) == null) {
            if (this.logFile_.equals(cLogCtx.file)) {
                clHeaders_.put(cLogCtx.file, this.clHeader_);
            } else {
                logger_.error((Object)("Unknown commitlog file " + cLogCtx.file));
                return;
            }
        }
        assert (cLogCtx.position >= (long)clHeaders_.get(cLogCtx.file).getPosition(id));
        ArrayList<String> oldFiles = new ArrayList<String>(clHeaders_.keySet());
        Collections.sort(oldFiles, new CommitLogFileComparator());
        for (String oldFile : oldFiles) {
            CommitLogHeader header = clHeaders_.get(oldFile);
            if (oldFile.equals(cLogCtx.file)) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Marking replay position " + cLogCtx.position + " on commit log " + oldFile));
                }
                header.turnOn(id, cLogCtx.position);
                if (oldFile.equals(this.logFile_)) {
                    this.seekAndWriteCommitLogHeader(header.toByteArray());
                    break;
                }
                this.writeOldCommitLogHeader(oldFile, header);
                break;
            }
            header.turnOff(id);
            if (header.isSafeToDelete()) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Deleting commit log:" + oldFile));
                }
                FileUtils.deleteAsync(oldFile);
                clHeaders_.remove(oldFile);
                continue;
            }
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Not safe to delete commit log " + oldFile + "; dirty is " + header.dirtyString()));
            }
            this.writeOldCommitLogHeader(oldFile, header);
        }
    }

    private void writeOldCommitLogHeader(String oldFile, CommitLogHeader header) throws IOException {
        BufferedRandomAccessFile logWriter = CommitLog.createWriter(oldFile);
        CommitLog.writeCommitLogHeader(logWriter, header.toByteArray());
        logWriter.close();
    }

    private boolean maybeRollLog() throws IOException {
        if (this.logWriter_.length() >= (long)SEGMENT_SIZE) {
            this.setNextFileName();
            String oldLogFile = this.logWriter_.getPath();
            this.logWriter_.close();
            this.logWriter_ = CommitLog.createWriter(this.logFile_);
            clHeaders_.put(oldLogFile, new CommitLogHeader(this.clHeader_));
            this.clHeader_.clear();
            CommitLog.writeCommitLogHeader(this.logWriter_, this.clHeader_.toByteArray());
            return true;
        }
        return false;
    }

    void sync() throws IOException {
        this.logWriter_.sync();
    }

    static {
        lock_ = new ReentrantLock();
        logger_ = Logger.getLogger(CommitLog.class);
        clHeaders_ = new HashMap<String, CommitLogHeader>();
    }

    class LogRecordAdder
    implements Callable<CommitLogContext> {
        Row row;

        LogRecordAdder(Row row) {
            this.row = row;
        }

        @Override
        public CommitLogContext call() throws Exception {
            long currentPosition = -1L;
            DataOutputBuffer cfBuffer = new DataOutputBuffer();
            try {
                Row.serializer().serialize(this.row, (DataOutputStream)cfBuffer);
                currentPosition = CommitLog.this.logWriter_.getFilePointer();
                CommitLogContext cLogCtx = new CommitLogContext(CommitLog.this.logFile_, currentPosition);
                CommitLog.this.maybeUpdateHeader(this.row);
                CommitLog.this.logWriter_.writeLong(cfBuffer.getLength());
                CommitLog.this.logWriter_.write(cfBuffer.getData(), 0, cfBuffer.getLength());
                CommitLog.this.maybeRollLog();
                return cLogCtx;
            }
            catch (IOException e) {
                if (currentPosition != -1L) {
                    CommitLog.this.logWriter_.seek(currentPosition);
                }
                throw e;
            }
        }
    }

    public static class CommitLogFileComparator
    implements Comparator<String> {
        @Override
        public int compare(String f, String f2) {
            return (int)(CommitLog.getCreationTime(f) - CommitLog.getCreationTime(f2));
        }
    }

    public static final class CommitLogContext {
        static CommitLogContext NULL = new CommitLogContext(null, -1L);
        public final String file;
        public final long position;

        public CommitLogContext(String file, long position) {
            this.file = file;
            this.position = position;
        }

        boolean isValidContext() {
            return this.position != -1L;
        }

        public String toString() {
            return "CommitLogContext(file='" + this.file + '\'' + ", position=" + this.position + ')';
        }
    }
}

