/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.lang.management.ManagementFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Context;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutorMBean;
import org.apache.cassandra.concurrent.ThreadFactoryImpl;
import org.apache.cassandra.concurrent.ThreadLocalContext;
import org.apache.log4j.Logger;

public class DebuggableThreadPoolExecutor
extends ThreadPoolExecutor
implements DebuggableThreadPoolExecutorMBean {
    private static Logger logger_ = Logger.getLogger(DebuggableThreadPoolExecutor.class);
    private ObjectName objName;

    public DebuggableThreadPoolExecutor(String threadPoolName) {
        this(1, 1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl(threadPoolName));
    }

    public DebuggableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactoryImpl threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        super.prestartAllCoreThreads();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.objName = new ObjectName("org.apache.cassandra.concurrent:type=" + threadFactory.id_);
            mbs.registerMBean(this, this.objName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getPendingTasks() {
        return this.getTaskCount() - this.getCompletedTaskCount();
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (r instanceof FutureTask) {
            assert (t == null);
            try {
                ((FutureTask)r).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                t = e;
            }
        }
        if (t != null) {
            Object object;
            Context ctx = ThreadLocalContext.get();
            if (ctx != null && (object = ctx.get(r.getClass().getName())) != null) {
                logger_.error((Object)("In afterExecute() " + t.getClass().getName() + " occured while working with " + object));
            }
            logger_.error((Object)"Error in ThreadPoolExecutor", t);
        }
    }
}

