/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import java.io.File;
import java.io.IOException;
import jline.ConsoleReader;
import jline.History;
import org.apache.cassandra.cli.CliClient;
import org.apache.cassandra.cli.CliOptions;
import org.apache.cassandra.cli.CliSessionState;
import org.apache.cassandra.service.Cassandra;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class CliMain {
    public static final String PROMPT = "cassandra";
    public static final String HISTORYFILE = ".cassandra.history";
    private static TTransport transport_ = null;
    private static Cassandra.Client thriftClient_ = null;
    private static CliSessionState css_ = new CliSessionState();
    private static CliClient cliClient_;

    public static void connect(String server, int port) {
        TSocket socket = new TSocket(server, port);
        if (transport_ != null) {
            transport_.close();
        }
        transport_ = socket;
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport_, false, false);
        Cassandra.Client cassandraClient = new Cassandra.Client((TProtocol)binaryProtocol);
        try {
            transport_.open();
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage());
            e.printStackTrace();
        }
        thriftClient_ = cassandraClient;
        cliClient_ = new CliClient(css_, thriftClient_);
        CliMain.css_.out.printf("Connected to %s/%d\n", server, port);
    }

    public static void disconnect() {
        if (transport_ != null) {
            transport_.close();
            transport_ = null;
        }
    }

    private static void printBanner() {
        CliMain.css_.out.println("Welcome to cassandra CLI.\n");
        CliMain.css_.out.println("Type 'help' or '?' for help. Type 'quit' or 'exit' to quit.");
    }

    public static boolean isConnected() {
        if (thriftClient_ == null) {
            CliMain.css_.out.println("Not connected to a cassandra instance.");
            return false;
        }
        return true;
    }

    private static void processCLIStmt(String query) {
        try {
            cliClient_.executeCLIStmt(query);
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) throws IOException {
        String line;
        CliOptions cliOptions = new CliOptions();
        cliOptions.processArgs(css_, args);
        if (CliMain.css_.hostName != null) {
            CliMain.connect(CliMain.css_.hostName, CliMain.css_.thriftPort);
        } else {
            cliClient_ = new CliClient(css_, null);
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        String historyFile = System.getProperty("user.home") + File.separator + HISTORYFILE;
        reader.setHistory(new History(new File(historyFile)));
        CliMain.printBanner();
        while ((line = reader.readLine("cassandra> ")) != null) {
            CliMain.processCLIStmt(line);
        }
    }
}

