/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.cassandra.cli.CliCompiler;
import org.apache.cassandra.cli.CliMain;
import org.apache.cassandra.cli.CliSessionState;
import org.apache.cassandra.cli.CliUtils;
import org.apache.cassandra.service.Cassandra;
import org.apache.cassandra.service.Column;
import org.apache.cassandra.service.ColumnOrSuperColumn;
import org.apache.cassandra.service.ColumnParent;
import org.apache.cassandra.service.ColumnPath;
import org.apache.cassandra.service.InvalidRequestException;
import org.apache.cassandra.service.NotFoundException;
import org.apache.cassandra.service.SlicePredicate;
import org.apache.cassandra.service.SliceRange;
import org.apache.cassandra.service.UnavailableException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.thrift.TException;

public class CliClient {
    private Cassandra.Client thriftClient_ = null;
    private CliSessionState css_ = null;

    public CliClient(CliSessionState css, Cassandra.Client thriftClient) {
        this.css_ = css;
        this.thriftClient_ = thriftClient;
    }

    public void executeCLIStmt(String stmt) throws TException, NotFoundException, InvalidRequestException, UnavailableException {
        CommonTree ast = null;
        ast = CliCompiler.compileQuery(stmt);
        switch (ast.getType()) {
            case 6: {
                this.cleanupAndExit();
                break;
            }
            case 13: {
                this.executeGet(ast);
                break;
            }
            case 7: {
                this.printCmdHelp();
                break;
            }
            case 14: {
                this.executeSet(ast);
                break;
            }
            case 9: {
                this.executeShowProperty(ast, "cluster name");
                break;
            }
            case 10: {
                this.executeShowProperty(ast, "config file");
                break;
            }
            case 11: {
                this.executeShowProperty(ast, "version");
                break;
            }
            case 12: {
                this.executeShowTables(ast);
                break;
            }
            case 5: {
                this.executeDescribeTable(ast);
                break;
            }
            case 4: {
                this.executeConnect(ast);
                break;
            }
            case 8: {
                break;
            }
            default: {
                this.css_.err.println("Invalid Statement (Type: " + ast.getType() + ")");
            }
        }
    }

    private void printCmdHelp() {
        this.css_.out.println("List of all CLI commands:");
        this.css_.out.println("?                                                      Same as help.");
        this.css_.out.println("connect <hostname>/<port>                              Connect to Cassandra's thrift service.");
        this.css_.out.println("describe keyspace <keyspacename>                       Describe keyspace.");
        this.css_.out.println("exit                                                   Exit CLI.");
        this.css_.out.println("help                                                   Display this help.");
        this.css_.out.println("quit                                                   Exit CLI.");
        this.css_.out.println("show config file                                       Display contents of config file");
        this.css_.out.println("show cluster name                                      Display cluster name.");
        this.css_.out.println("show keyspaces                                         Show list of keyspaces.");
        this.css_.out.println("show version                                           Show server version.");
        this.css_.out.println("get <tbl>.<cf>['<rowKey>']                             Get a slice of columns.");
        this.css_.out.println("get <tbl>.<cf>['<rowKey>']['<colKey>']                 Get a column value.");
        this.css_.out.println("set <tbl>.<cf>['<rowKey>']['<colKey>'] = '<value>'     Set a column.");
    }

    private void cleanupAndExit() {
        CliMain.disconnect();
        System.exit(0);
    }

    private void executeGet(CommonTree ast) throws TException, NotFoundException, InvalidRequestException, UnavailableException {
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = ast.getChildCount();
        assert (childCount == 1);
        CommonTree columnFamilySpec = (CommonTree)ast.getChild(0);
        assert (columnFamilySpec.getType() == 15);
        String tableName = CliCompiler.getTableName(columnFamilySpec);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        if (columnSpecCnt == 0) {
            SliceRange range = new SliceRange(ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.EMPTY_BYTE_ARRAY, true, 1000000);
            List<ColumnOrSuperColumn> columns = this.thriftClient_.get_slice(tableName, key, new ColumnParent(columnFamily, null), new SlicePredicate(null, range), 1);
            int size = columns.size();
            for (ColumnOrSuperColumn cosc : columns) {
                Column column = cosc.column;
                try {
                    this.css_.out.printf("  (column=%s, value=%s; timestamp=%d)\n", new String(column.name, "UTF-8"), new String(column.value, "UTF-8"), column.timestamp);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            this.css_.out.println("Returned " + size + " rows.");
        } else {
            assert (columnSpecCnt == 1);
            String columnName = CliCompiler.getColumn(columnFamilySpec, 0);
            try {
                ColumnOrSuperColumn cosc = this.thriftClient_.get(tableName, key, new ColumnPath(columnFamily, null, columnName.getBytes("UTF-8")), 1);
                Column column = cosc.column;
                this.css_.out.printf("==> (name=%s, value=%s; timestamp=%d)\n", new String(column.name, "UTF-8"), new String(column.value, "UTF-8"), column.timestamp);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void executeSet(CommonTree ast) throws TException, InvalidRequestException, UnavailableException {
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = ast.getChildCount();
        assert (childCount == 2);
        CommonTree columnFamilySpec = (CommonTree)ast.getChild(0);
        assert (columnFamilySpec.getType() == 15);
        String tableName = CliCompiler.getTableName(columnFamilySpec);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        String value = CliUtils.unescapeSQLString(ast.getChild(1).getText());
        if (columnSpecCnt == 1) {
            String columnName = CliCompiler.getColumn(columnFamilySpec, 0);
            try {
                this.thriftClient_.insert(tableName, key, new ColumnPath(columnFamily, null, columnName.getBytes("UTF-8")), value.getBytes(), System.currentTimeMillis(), 1);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.css_.out.println("Value inserted.");
        } else assert (false);
    }

    private void executeShowProperty(CommonTree ast, String propertyName) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        String propertyValue = this.thriftClient_.get_string_property(propertyName);
        this.css_.out.println(propertyValue);
    }

    private void executeShowTables(CommonTree ast) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        List<String> tables = this.thriftClient_.get_string_list_property("keyspaces");
        for (String table : tables) {
            this.css_.out.println(table);
        }
    }

    private void executeDescribeTable(CommonTree ast) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = ast.getChildCount();
        assert (childCount == 1);
        String tableName = ast.getChild(0).getText();
        try {
            Map<String, Map<String, String>> columnFamiliesMap = this.thriftClient_.describe_keyspace(tableName);
            for (String columnFamilyName : columnFamiliesMap.keySet()) {
                Map<String, String> columnMap = columnFamiliesMap.get(columnFamilyName);
                String desc = columnMap.get("Desc");
                String columnFamilyType = columnMap.get("Type");
                String sort = columnMap.get("CompareWith");
                String flushperiod = columnMap.get("FlushPeriodInMinutes");
                this.css_.out.println(desc);
                this.css_.out.println("Column Family Type: " + columnFamilyType);
                this.css_.out.println("Column Sorted By: " + sort);
                this.css_.out.println("flush period: " + flushperiod + " minutes");
                this.css_.out.println("------");
            }
        }
        catch (NotFoundException e) {
            this.css_.out.println("Keyspace " + tableName + " could not be found.");
        }
    }

    private void executeConnect(CommonTree ast) throws TException {
        int portNumber = Integer.parseInt(ast.getChild(1).getText());
        Tree idList = ast.getChild(0);
        StringBuilder hostName = new StringBuilder();
        int idCount = idList.getChildCount();
        for (int idx = 0; idx < idCount; ++idx) {
            hostName.append(idList.getChild(idx).getText());
        }
        CliMain.disconnect();
        this.css_.hostName = hostName.toString();
        this.css_.thriftPort = portNumber;
        CliMain.connect(this.css_.hostName, this.css_.thriftPort);
    }
}

