/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import jakarta.annotation.PreDestroy;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.Main;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.main.SimpleMainShutdownStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CamelSpringBootApplicationController {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootApplicationController.class);
    private final Main main;

    public CamelSpringBootApplicationController(ApplicationContext applicationContext, CamelContext context) {
        this.main = new CamelSpringMain(applicationContext, context);
    }

    public MainShutdownStrategy getMainShutdownStrategy() {
        return this.main.getShutdownStrategy();
    }

    public Runnable getMainCompletedTask() {
        return this.main.getCompleteTask();
    }

    public void run() {
        LOG.debug("Controller is starting and waiting for Spring-Boot to stop or JVM to terminate");
        try {
            this.main.run();
            LOG.debug("Waiting for CamelContext to complete shutdown");
            this.main.getShutdownStrategy().await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.debug("CamelContext shutdown complete.");
    }

    @Deprecated
    public void blockMainThread() {
        this.run();
    }

    @PreDestroy
    void destroy() {
        this.main.completed();
    }

    private static class CamelSpringMain
    extends Main {
        final ApplicationContext applicationContext;

        public CamelSpringMain(ApplicationContext applicationContext, CamelContext camelContext) {
            this.applicationContext = applicationContext;
            this.camelContext = camelContext;
            this.shutdownStrategy = new SimpleMainShutdownStrategy();
            this.mainConfigurationProperties.setRoutesCollectorEnabled(false);
        }

        protected ProducerTemplate findOrCreateCamelTemplate() {
            return (ProducerTemplate)this.applicationContext.getBean(ProducerTemplate.class);
        }

        protected CamelContext createCamelContext() {
            return this.camelContext;
        }

        protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        }
    }
}

