/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class CamelVirtualThreadEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelVirtualThreadEnvironmentPostProcessor.class);
    private static final int VIRTUAL_THREADS_MIN_JAVA_VERSION = 21;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String springVirtualThreads = environment.getProperty("spring.threads.virtual.enabled");
        if ("true".equalsIgnoreCase(springVirtualThreads)) {
            int javaVersion = Runtime.version().feature();
            if (javaVersion < 21) {
                LOG.debug("spring.threads.virtual.enabled=true but running on JDK {} (virtual threads require JDK 21+)", (Object)javaVersion);
                return;
            }
            String existingCamelProperty = System.getProperty("camel.threads.virtual.enabled");
            if (existingCamelProperty == null) {
                System.setProperty("camel.threads.virtual.enabled", "true");
                LOG.info("Spring virtual threads enabled - automatically setting camel.threads.virtual.enabled=true");
            } else {
                LOG.debug("camel.threads.virtual.enabled already set to: {}", (Object)existingCamelProperty);
            }
        }
    }
}

