/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.ApplicationContext;

public class SpringBootRoutesCollector
extends DefaultRoutesCollector {
    private final ApplicationContext applicationContext;

    public SpringBootRoutesCollector(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
        Set lrbs = camelContext.getRegistry().findByType(LambdaRouteBuilder.class);
        for (final LambdaRouteBuilder lrb : lrbs) {
            RouteBuilder rb = new RouteBuilder(){

                public void configure() throws Exception {
                    lrb.accept((Object)this);
                }
            };
            routes.add((RoutesBuilder)rb);
        }
        AntPathMatcher matcher = new AntPathMatcher();
        for (RoutesBuilder routesBuilder : this.applicationContext.getBeansOfType(RoutesBuilder.class, true, true).values()) {
            String[] parts;
            boolean match;
            boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
            if (abs) continue;
            String name = routesBuilder.getClass().getName();
            name = name.replace('.', '/');
            boolean bl = match = !"false".equals(includePattern);
            if (match && ObjectHelper.isNotEmpty((Object)excludePattern)) {
                String[] parts2;
                for (String part : parts2 = excludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            String sysExcludePattern = System.getProperty("CamelTestSpringExcludeRoutes");
            if (match && ObjectHelper.isNotEmpty((Object)sysExcludePattern)) {
                sysExcludePattern = sysExcludePattern.replace('.', '/');
                for (String part : parts = sysExcludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty((Object)includePattern)) {
                for (String part : parts = includePattern.split(",")) {
                    match = matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                    if (match) break;
                }
            }
            this.log.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
            if (!match) continue;
            routes.add(routesBuilder);
        }
        return routes;
    }
}

