/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.springframework.context.ApplicationContext;

public class CamelMainRunController {
    private final CamelSpringBootApplicationController controller;
    private final Thread daemon;

    public CamelMainRunController(ApplicationContext applicationContext, CamelContext camelContext) {
        this.controller = new CamelSpringBootApplicationController(applicationContext, camelContext);
        this.daemon = new Thread((Runnable)new DaemonTask(), "CamelMainRunController");
    }

    public void start() {
        this.daemon.start();
    }

    public CountDownLatch getLatch() {
        return this.controller.getLatch();
    }

    public Runnable getMainCompleteTask() {
        return this.controller.getMainCompletedTask();
    }

    public AtomicBoolean getCompleted() {
        return this.controller.getCompleted();
    }

    private final class DaemonTask
    implements Runnable {
        private DaemonTask() {
        }

        @Override
        public void run() {
            CamelMainRunController.this.controller.run();
        }
    }
}

