/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.springboot.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifier;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryFactory;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyFactory;
import org.apache.camel.component.micrometer.springboot.metrics.CamelMetricsConfiguration;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;

@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={CamelMetricsConfiguration.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelMetricsAutoConfiguration {
    public CamelMetricsAutoConfiguration(CamelContext camelContext, CamelMetricsConfiguration configuration, MeterRegistry meterRegistry) {
        if (meterRegistry != null) {
            this.configureMicrometer(camelContext, configuration, meterRegistry);
        }
    }

    private void configureMicrometer(CamelContext camelContext, CamelMetricsConfiguration configuration, MeterRegistry meterRegistry) {
        MicrometerExchangeEventNotifier notifier;
        if (configuration.isEnableRoutePolicy()) {
            MicrometerRoutePolicyFactory factory = new MicrometerRoutePolicyFactory();
            factory.setMeterRegistry(meterRegistry);
            camelContext.addRoutePolicyFactory((RoutePolicyFactory)factory);
        }
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        if (configuration.isEnableExchangeEventNotifier()) {
            notifier = new MicrometerExchangeEventNotifier();
            notifier.setMeterRegistry(meterRegistry);
            managementStrategy.addEventNotifier((EventNotifier)notifier);
        }
        if (configuration.isEnableRouteEventNotifier()) {
            notifier = new MicrometerRouteEventNotifier();
            notifier.setMeterRegistry(meterRegistry);
            managementStrategy.addEventNotifier((EventNotifier)notifier);
        }
        if (configuration.isEnableMessageHistory()) {
            if (!camelContext.isMessageHistory().booleanValue()) {
                camelContext.setMessageHistory(Boolean.valueOf(true));
            }
            MicrometerMessageHistoryFactory factory = new MicrometerMessageHistoryFactory();
            factory.setMeterRegistry(meterRegistry);
            camelContext.setMessageHistoryFactory((MessageHistoryFactory)factory);
        }
    }
}

