/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xpath;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="xpath")
public class XPathLanguage
extends SingleInputTypedLanguageSupport
implements PropertyConfigurer {
    private QName resultQName;
    private Class<?> documentType;
    private XPathFactory xpathFactory;
    private Boolean saxon;
    private String objectModelUri;
    private Boolean threadSafety;
    private Boolean logNamespaces;
    private Boolean preCompile;

    public Predicate createPredicate(Expression source, String expression, Object[] properties) {
        expression = this.loadResource(expression);
        XPathBuilder builder = XPathBuilder.xpath(expression);
        this.configureBuilder(builder, properties, source);
        builder.setResultQName(XPathConstants.BOOLEAN);
        return builder;
    }

    public Expression createExpression(Expression source, String expression, Object[] properties) {
        expression = this.loadResource(expression);
        XPathBuilder builder = XPathBuilder.xpath(expression);
        this.configureBuilder(builder, properties, source);
        return builder;
    }

    public void setResultQName(QName qName) {
        this.resultQName = qName;
    }

    public QName getResultQName() {
        return this.resultQName;
    }

    public Class<?> getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Class<?> documentType) {
        this.documentType = documentType;
    }

    public XPathFactory getXpathFactory() {
        return this.xpathFactory;
    }

    public void setXpathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public Boolean getSaxon() {
        return this.saxon;
    }

    public void setSaxon(Boolean saxon) {
        this.saxon = saxon;
    }

    public String getObjectModelUri() {
        return this.objectModelUri;
    }

    public void setObjectModelUri(String objectModelUri) {
        this.objectModelUri = objectModelUri;
    }

    public Boolean getThreadSafety() {
        return this.threadSafety;
    }

    public void setThreadSafety(Boolean threadSafety) {
        this.threadSafety = threadSafety;
    }

    public Boolean getLogNamespaces() {
        return this.logNamespaces;
    }

    public void setLogNamespaces(Boolean logNamespaces) {
        this.logNamespaces = logNamespaces;
    }

    public Boolean getPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(Boolean preCompile) {
        this.preCompile = preCompile;
    }

    protected void configureBuilder(XPathBuilder builder, Object[] properties, Expression source) {
        Map ns;
        Boolean bool;
        QName qname;
        builder.setSource(source);
        Class clazz = (Class)this.property(Class.class, properties, 0, null);
        if (clazz != null) {
            builder.setResultType(clazz);
        }
        if ((clazz = (Class)this.property(Class.class, properties, 2, this.documentType)) != null) {
            builder.setDocumentType(clazz);
        }
        if ((qname = (QName)this.property(QName.class, properties, 3, this.resultQName)) != null) {
            builder.setResultQName(qname);
        }
        if ((bool = (Boolean)this.property(Boolean.class, properties, 4, this.saxon)) != null) {
            builder.setUseSaxon(bool);
            if (bool.booleanValue()) {
                builder.enableSaxon();
            }
        }
        if (!builder.isUseSaxon()) {
            String str;
            XPathFactory fac = (XPathFactory)this.property(XPathFactory.class, properties, 5, this.xpathFactory);
            if (fac != null) {
                builder.setXPathFactory(fac);
            }
            if ((str = (String)this.property(String.class, properties, 6, this.objectModelUri)) != null) {
                builder.setObjectModelUri(str);
            }
        }
        if ((bool = (Boolean)this.property(Boolean.class, properties, 7, this.threadSafety)) != null) {
            builder.setThreadSafety(bool);
        }
        if ((bool = (Boolean)this.property(Boolean.class, properties, 8, this.preCompile)) != null) {
            builder.setPreCompile(bool);
        }
        if ((bool = (Boolean)this.property(Boolean.class, properties, 9, this.logNamespaces)) != null) {
            builder.setLogNamespaces(bool);
        }
        if ((ns = (Map)this.property(Map.class, properties, 10, null)) != null && !ns.isEmpty()) {
            builder.setNamespaces(ns);
        }
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resultqname": 
            case "resultQName": {
                this.setResultQName((QName)PropertyConfigurerSupport.property((CamelContext)camelContext, QName.class, (Object)value));
                return true;
            }
            case "documenttype": 
            case "documentType": {
                this.setDocumentType((Class)PropertyConfigurerSupport.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "xpathfactory": 
            case "xpathFactory": {
                this.setXpathFactory((XPathFactory)PropertyConfigurerSupport.property((CamelContext)camelContext, XPathFactory.class, (Object)value));
                return true;
            }
            case "saxon": {
                this.setSaxon((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "objectmodeluri": 
            case "objectModelUri": {
                this.setObjectModelUri((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "threadsafety": 
            case "threadSafety": {
                this.setThreadSafety((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "lognamespaces": 
            case "logNamespaces": {
                this.setLogNamespaces((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "preCompile": 
            case "precompile": {
                this.setPreCompile((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
        }
        return false;
    }
}

