/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

public final class CamelVersionHelper {
    private CamelVersionHelper() {
    }

    public static boolean isGE(String base, String other) {
        if (base == null || base.isEmpty()) {
            throw new IllegalArgumentException("Empty base version");
        }
        if (other == null || other.isEmpty()) {
            throw new IllegalArgumentException("Empty other version");
        }
        base = base.replaceAll("[^\\d|^\\.]", "");
        other = other.replaceAll("[^\\d|^\\.]", "");
        if (!base.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        if (!other.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        Version ver2 = new Version(other);
        Version ver1 = new Version(base);
        return ver2.compareTo(ver1) >= 0;
    }

    public static String prevMinor(String base) {
        if (base == null || base.isEmpty()) {
            throw new IllegalArgumentException("Empty base version");
        }
        if (!(base = base.replaceAll("[^\\d|^\\.]", "")).matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        Version ver = new Version(base);
        return ver.prevMinor();
    }

    private static final class Version
    implements Comparable<Version> {
        private final String version;

        private Version(String version) {
            this.version = version;
        }

        private String getVersion() {
            return this.version;
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            String[] thisParts = this.getVersion().split("\\.");
            String[] thatParts = that.getVersion().split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            for (int i = 0; i < length; ++i) {
                long thatPart;
                long thisPart = i < thisParts.length ? Long.parseLong(thisParts[i]) : 0L;
                long l = thatPart = i < thatParts.length ? Long.parseLong(thatParts[i]) : 0L;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return 0;
        }

        public String prevMinor() {
            int patch;
            String[] parts = this.getVersion().split("\\.");
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int n = patch = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
            if (minor > 0) {
                --minor;
            }
            String prev = major + "." + minor + "." + patch;
            return prev;
        }

        public String toString() {
            return this.version;
        }
    }
}

