/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.ApiModel;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.Comparators;

public class ComponentModel
extends ArtifactModel<ComponentOptionModel> {
    protected String scheme;
    protected String extendsScheme;
    protected String alternativeSchemes;
    protected String syntax;
    protected String alternativeSyntax;
    protected boolean async;
    protected boolean api;
    protected String apiSyntax;
    protected boolean consumerOnly;
    protected boolean producerOnly;
    protected boolean lenientProperties;
    protected String verifiers;
    protected final List<EndpointOptionModel> endpointOptions = new ArrayList<EndpointOptionModel>();
    protected final List<EndpointHeaderModel> headers = new ArrayList<EndpointHeaderModel>();
    protected final Collection<ApiModel> apiOptions = new TreeSet<ApiModel>(Comparators.apiModelComparator());

    @Override
    public String getKind() {
        return "component";
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getExtendsScheme() {
        return this.extendsScheme;
    }

    public void setExtendsScheme(String extendsScheme) {
        this.extendsScheme = extendsScheme;
    }

    public String getAlternativeSchemes() {
        return this.alternativeSchemes;
    }

    public void setAlternativeSchemes(String alternativeSchemes) {
        this.alternativeSchemes = alternativeSchemes;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public String getAlternativeSyntax() {
        return this.alternativeSyntax;
    }

    public void setAlternativeSyntax(String alternativeSyntax) {
        this.alternativeSyntax = alternativeSyntax;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isApi() {
        return this.api;
    }

    public void setApi(boolean api) {
        this.api = api;
    }

    public String getApiSyntax() {
        return this.apiSyntax;
    }

    public void setApiSyntax(String apiSyntax) {
        this.apiSyntax = apiSyntax;
    }

    public boolean isConsumerOnly() {
        return this.consumerOnly;
    }

    public void setConsumerOnly(boolean consumerOnly) {
        this.consumerOnly = consumerOnly;
    }

    public boolean isProducerOnly() {
        return this.producerOnly;
    }

    public void setProducerOnly(boolean producerOnly) {
        this.producerOnly = producerOnly;
    }

    public boolean isLenientProperties() {
        return this.lenientProperties;
    }

    public void setLenientProperties(boolean lenientProperties) {
        this.lenientProperties = lenientProperties;
    }

    public String getVerifiers() {
        return this.verifiers;
    }

    public void setVerifiers(String verifiers) {
        this.verifiers = verifiers;
    }

    public List<ComponentOptionModel> getComponentOptions() {
        return super.getOptions();
    }

    public void addComponentOption(ComponentOptionModel option) {
        super.addOption(option);
    }

    public List<EndpointOptionModel> getEndpointOptions() {
        return this.endpointOptions;
    }

    public void addEndpointOption(EndpointOptionModel option) {
        this.endpointOptions.add(option);
    }

    public List<EndpointHeaderModel> getEndpointHeaders() {
        return this.headers;
    }

    public void addEndpointHeader(EndpointHeaderModel header) {
        this.headers.add(header);
    }

    public List<EndpointOptionModel> getEndpointParameterOptions() {
        return this.endpointOptions.stream().filter(o -> "parameter".equals(o.getKind())).collect(Collectors.toList());
    }

    public List<EndpointOptionModel> getEndpointPathOptions() {
        return this.endpointOptions.stream().filter(o -> "path".equals(o.getKind())).collect(Collectors.toList());
    }

    public Collection<ApiModel> getApiOptions() {
        return this.apiOptions;
    }

    public static class ApiOptionModel
    extends BaseOptionModel
    implements Cloneable {
        private boolean optional;

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public ApiOptionModel copy() {
            try {
                return (ApiOptionModel)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ApiOptionModel copy = (ApiOptionModel)super.clone();
            if (this.getEnums() != null) {
                copy.setEnums(new ArrayList<String>(this.getEnums()));
            }
            if (this.getOneOfs() != null) {
                copy.setOneOfs(new ArrayList<String>(this.getOneOfs()));
            }
            return copy;
        }
    }

    public static class EndpointOptionModel
    extends BaseOptionModel {
    }

    public static class ComponentOptionModel
    extends BaseOptionModel {
    }

    public static class EndpointHeaderModel
    extends BaseOptionModel {
    }
}

