/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.StartupListener;
import org.apache.camel.Suspendable;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerConsumer
extends DefaultConsumer
implements StartupListener,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(TimerConsumer.class);
    private final TimerEndpoint endpoint;
    private volatile TimerTask task;
    private volatile boolean configured;
    private ExecutorService executorService;

    public TimerConsumer(TimerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public TimerEndpoint getEndpoint() {
        return (TimerEndpoint)super.getEndpoint();
    }

    public void doInit() throws Exception {
        if (this.endpoint.getDelay() >= 0L) {
            this.task = new TimerTask(){
                private final AtomicLong counter = new AtomicLong();

                @Override
                public void run() {
                    if (!TimerConsumer.this.isTaskRunAllowed()) {
                        LOG.debug("Run not allowed for timer: {}", (Object)TimerConsumer.this.endpoint);
                        return;
                    }
                    try {
                        boolean fire;
                        long count = this.counter.incrementAndGet();
                        boolean bl = fire = TimerConsumer.this.endpoint.getRepeatCount() <= 0L || count <= TimerConsumer.this.endpoint.getRepeatCount();
                        if (fire) {
                            TimerConsumer.this.sendTimerExchange(count);
                        } else {
                            LOG.debug("Cancelling {} timer as repeat count limit reached after {} counts.", (Object)TimerConsumer.this.endpoint.getTimerName(), (Object)TimerConsumer.this.endpoint.getRepeatCount());
                            this.cancel();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error processing exchange. This exception will be ignored, to let the timer be able to trigger again.", (Throwable)e);
                    }
                }
            };
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.endpoint.getDelay() >= 0L) {
            if (this.task != null && !this.configured && this.endpoint.getCamelContext().getStatus().isStarted()) {
                Timer timer = this.endpoint.getTimer(this);
                this.configureTask(this.task, timer);
            }
        } else {
            this.executorService = this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, this.endpoint.getEndpointUri());
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    AtomicLong counter = new AtomicLong();
                    long count = counter.incrementAndGet();
                    while ((TimerConsumer.this.endpoint.getRepeatCount() <= 0L || count <= TimerConsumer.this.endpoint.getRepeatCount()) && TimerConsumer.this.isRunAllowed()) {
                        TimerConsumer.this.sendTimerExchange(count);
                        count = counter.incrementAndGet();
                    }
                }
            });
        }
    }

    protected void doStop() throws Exception {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        this.configured = false;
        this.endpoint.removeTimer(this);
        if (this.executorService != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executorService);
            this.executorService = null;
        }
        super.doStop();
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        if (this.task != null && !this.configured) {
            Timer timer = this.endpoint.getTimer(this);
            this.configureTask(this.task, timer);
        }
    }

    protected boolean isTaskRunAllowed() {
        return this.isStarted();
    }

    protected void configureTask(TimerTask task, Timer timer) {
        if (this.endpoint.isFixedRate()) {
            if (this.endpoint.getTime() != null) {
                timer.scheduleAtFixedRate(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.scheduleAtFixedRate(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
            }
        } else if (this.endpoint.getTime() != null) {
            if (this.endpoint.getPeriod() > 0L) {
                timer.schedule(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.schedule(task, this.endpoint.getTime());
            }
        } else if (this.endpoint.getPeriod() > 0L) {
            timer.schedule(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
        } else {
            timer.schedule(task, this.endpoint.getDelay());
        }
        this.configured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTimerExchange(long counter) {
        Exchange exchange = this.createExchange(false);
        if (this.endpoint.isIncludeMetadata()) {
            exchange.setProperty("CamelTimerCounter", (Object)counter);
            exchange.setProperty("CamelTimerName", (Object)this.endpoint.getTimerName());
            exchange.setProperty("CamelTimerTime", (Object)this.endpoint.getTime());
            exchange.setProperty("CamelTimerPeriod", (Object)this.endpoint.getPeriod());
            Date now = new Date();
            exchange.setProperty("CamelTimerFiredTime", (Object)now);
            exchange.getIn().setHeader("firedTime", (Object)now);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Timer {} is firing #{} count", (Object)this.endpoint.getTimerName(), (Object)counter);
        }
        if (!this.endpoint.isSynchronous()) {
            AsyncCallback cb = this.defaultConsumerCallback(exchange, false);
            this.getAsyncProcessor().process(exchange, cb);
        } else {
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            try {
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
            finally {
                this.releaseExchange(exchange, false);
            }
        }
    }
}

