/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.propagation;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.telemetry.SpanContextPropagationExtractor;
import org.apache.camel.util.CaseInsensitiveMap;

public final class CamelJMSHeadersSpanContextPropagationExtractor
implements SpanContextPropagationExtractor {
    private final Map<String, Object> map = new CaseInsensitiveMap();

    public CamelJMSHeadersSpanContextPropagationExtractor(Map<String, Object> map) {
        map.entrySet().stream().filter(e -> e.getValue() instanceof String || e.getValue() instanceof byte[]).forEach(e -> {
            Object patt0$temp = e.getValue();
            if (patt0$temp instanceof byte[]) {
                byte[] bytes = (byte[])patt0$temp;
                this.map.put(this.decodeDash((String)e.getKey()), new String(bytes, StandardCharsets.UTF_8));
            } else {
                this.map.put(this.decodeDash((String)e.getKey()), e.getValue());
            }
        });
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public Set<String> keys() {
        return this.map.keySet();
    }

    private String decodeDash(String key) {
        if (key != null) {
            return key.replace("__dash__", "-");
        }
        return key;
    }
}

