/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.decorators.AbstractSpanDecorator;

public abstract class AbstractHttpSpanDecorator
extends AbstractSpanDecorator {
    public static final String POST_METHOD = "POST";
    public static final String GET_METHOD = "GET";

    public String getHttpMethod(Exchange exchange, Endpoint endpoint) {
        Object method = exchange.getIn().getHeader("CamelHttpMethod");
        if (method instanceof String) {
            return (String)method;
        }
        if (method instanceof Enum) {
            return ((Enum)method).name();
        }
        if (method != null) {
            return (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange, method);
        }
        if (exchange.getIn().getHeader("CamelHttpQuery") != null) {
            return GET_METHOD;
        }
        if (endpoint.getEndpointUri().indexOf(63) != -1) {
            return GET_METHOD;
        }
        if (exchange.getIn().getBody() != null) {
            return POST_METHOD;
        }
        return GET_METHOD;
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return this.getHttpMethod(exchange, endpoint);
    }

    @Override
    public void beforeTracingEvent(Span span, Exchange exchange, Endpoint endpoint) {
        super.beforeTracingEvent(span, exchange, endpoint);
        String httpUrl = this.getHttpURL(exchange, endpoint);
        if (httpUrl != null) {
            span.setTag("http.url", httpUrl);
        }
        span.setTag("http.method", this.getHttpMethod(exchange, endpoint));
    }

    protected String getHttpURL(Exchange exchange, Endpoint endpoint) {
        Object url = exchange.getIn().getHeader("CamelHttpUrl");
        if (url instanceof String) {
            return (String)url;
        }
        Object uri = exchange.getIn().getHeader("CamelHttpUri");
        if (uri instanceof String) {
            return (String)uri;
        }
        int index = endpoint.getEndpointUri().lastIndexOf("http:");
        if (index != -1) {
            return endpoint.getEndpointUri().substring(index);
        }
        return null;
    }

    @Override
    public void afterTracingEvent(Span span, Exchange exchange) {
        Integer responseCode;
        super.afterTracingEvent(span, exchange);
        Message message = exchange.getMessage();
        if (message != null && (responseCode = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class)) != null) {
            span.setTag("http.status_code", responseCode.toString());
        }
    }
}

