/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import java.net.http.HttpClient;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="telegram")
public class TelegramComponent
extends HealthCheckComponent {
    public static final String BOT_API_DEFAULT_URL = "https://api.telegram.org";
    @Metadata(label="security", secret=true)
    private String authorizationToken;
    @Metadata(label="advanced")
    private HttpClient client;
    @Metadata(label="advanced", defaultValue="https://api.telegram.org", description="Can be used to set an alternative base URI, e.g. when you want to test the component against a mock Telegram API")
    private String baseUri = "https://api.telegram.org";

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TelegramConfiguration configuration = new TelegramConfiguration();
        if (remaining.endsWith("/")) {
            remaining = remaining.substring(0, remaining.length() - 1);
        }
        configuration.setType(remaining);
        if (!remaining.equals("bots")) {
            throw new IllegalArgumentException("Unsupported endpoint type for uri " + uri + ", remaining " + remaining);
        }
        if (configuration.getBaseUri() == null) {
            configuration.setBaseUri(this.baseUri);
        }
        TelegramEndpoint endpoint = new TelegramEndpoint(uri, (Component)this, configuration, this.client);
        configuration.setAuthorizationToken(this.authorizationToken);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().getAuthorizationToken() == null) {
            throw new IllegalArgumentException("AuthorizationToken must be configured on either component or endpoint for telegram: " + uri);
        }
        return endpoint;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String telegramBaseUri) {
        this.baseUri = telegramBaseUri;
    }
}

