package org.apache.camel.component.syslog;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class SyslogConverterLoader implements TypeConverterLoader {

    public SyslogConverterLoader() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        addTypeConverter(registry, java.lang.String.class, org.apache.camel.component.syslog.SyslogMessage.class, false,
            (type, exchange, value) -> org.apache.camel.component.syslog.SyslogConverter.toString((org.apache.camel.component.syslog.SyslogMessage) value));
        addTypeConverter(registry, org.apache.camel.component.syslog.SyslogMessage.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.component.syslog.SyslogConverter.toSyslogMessage((java.lang.String) value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { 
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

}
