/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.syslog;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.syslog.SyslogConverter;
import org.apache.camel.component.syslog.SyslogMessage;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

public class SyslogConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(2);

    private void registerConverters() {
        this.converters.put(String.class, SyslogMessage.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return SyslogConverter.toString((SyslogMessage)value);
            }
        });
        this.converters.put(SyslogMessage.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return SyslogConverter.toSyslogMessage((String)value);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

