/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import java.time.Duration;
import java.time.Instant;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.support.task.budget.backoff.BackOffStrategy;
import org.apache.camel.support.task.budget.backoff.FixedBackOffStrategy;

public class IterationBoundedBudget
implements IterationBudget {
    public static final int UNLIMITED_ITERATIONS = -1;
    private final long initialDelay;
    private final int maxIterations;
    private final BackOffStrategy backOffStrategy;
    private final Instant startTime;
    private int iterations;

    IterationBoundedBudget(long initialDelay, long interval, int maxIterations) {
        this.initialDelay = initialDelay;
        this.maxIterations = maxIterations;
        this.backOffStrategy = new FixedBackOffStrategy(interval);
        this.startTime = Instant.now();
    }

    IterationBoundedBudget(long initialDelay, int maxIterations, BackOffStrategy backOffStrategy) {
        this.initialDelay = initialDelay;
        this.maxIterations = maxIterations;
        this.backOffStrategy = backOffStrategy;
        this.startTime = Instant.now();
    }

    @Override
    public long initialDelay() {
        return this.initialDelay;
    }

    @Override
    public long interval() {
        return this.backOffStrategy.calculateInterval(this.iterations);
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int iteration() {
        return this.iterations;
    }

    @Override
    public boolean next() {
        if (this.canContinue()) {
            if (this.iterations != -1) {
                ++this.iterations;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        if (this.maxIterations != -1) {
            return this.iterations < this.maxIterations;
        }
        return true;
    }

    @Override
    public Duration elapsed() {
        return Duration.between(this.startTime, Instant.now());
    }
}

