/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.scan;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.NonManagedService;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.scan.AnnotatedWithAnyPackageScanFilter;
import org.apache.camel.support.scan.AnnotatedWithPackageScanFilter;
import org.apache.camel.support.scan.AssignableToPackageScanFilter;
import org.apache.camel.support.scan.BasePackageScanResolver;
import org.apache.camel.support.scan.CompositePackageScanFilter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageScanClassResolver
extends BasePackageScanResolver
implements PackageScanClassResolver,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPackageScanClassResolver.class);
    private volatile Map<String, List<String>> jarCache;
    private Set<PackageScanFilter> scanFilters;

    public void addFilter(PackageScanFilter filter) {
        if (this.scanFilters == null) {
            this.scanFilters = new LinkedHashSet<PackageScanFilter>();
        }
        this.scanFilters.add(filter);
    }

    public void removeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            this.scanFilters.remove(filter);
        }
    }

    public Set<Class<?>> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for annotations of {} in packages: {}", (Object)annotation.getName(), Arrays.asList(packageNames));
        }
        PackageScanFilter test = this.getCompositeFilter(new AnnotatedWithPackageScanFilter(annotation, true));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        LOG.debug("Found: {}", classes);
        return classes;
    }

    public Set<Class<?>> findAnnotated(Set<Class<? extends Annotation>> annotations, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for annotations of {} in packages: {}", annotations, Arrays.asList(packageNames));
        }
        PackageScanFilter test = this.getCompositeFilter(new AnnotatedWithAnyPackageScanFilter(annotations, true));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        LOG.debug("Found: {}", classes);
        return classes;
    }

    public Set<Class<?>> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for implementations of {} in packages: {}", (Object)parent.getName(), Arrays.asList(packageNames));
        }
        PackageScanFilter test = this.getCompositeFilter(new AssignableToPackageScanFilter(parent));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        LOG.debug("Found: {}", classes);
        return classes;
    }

    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        LOG.debug("Found: {}", classes);
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = ".".equals(packageName) ? "" : packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        for (ClassLoader classLoader : set) {
            this.find(test, packageName, classLoader, classes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        Enumeration<URL> urls;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Searching for: {} in package: {} using classloader: {}", new Object[]{test, packageName, loader.getClass().getName()});
        }
        if ((urls = this.getUrls(packageName, loader)) == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                url = urls.nextElement();
                LOG.trace("URL from classloader: {}", (Object)url);
                url = this.customResourceLocator(url);
                String urlPath = this.parseUrlPath(url);
                if (urlPath == null) continue;
                LOG.trace("Scanning for classes in: {} matching criteria: {}", (Object)urlPath, (Object)test);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    LOG.trace("Loading from directory using file: {}", (Object)file);
                    this.loadImplementationsInDirectory(test, packageName, file, classes);
                    continue;
                }
                InputStream stream = null;
                try {
                    if (urlPath.startsWith("http:") || urlPath.startsWith("https:") || urlPath.startsWith("sonicfs:") || this.isAcceptableScheme(urlPath)) {
                        LOG.trace("Loading from jar using url: {}", (Object)urlPath);
                        URL urlStream = URI.create(urlPath).toURL();
                        URLConnection con = urlStream.openConnection();
                        con.setUseCaches(false);
                        stream = con.getInputStream();
                    } else {
                        LOG.trace("Loading from jar using file: {}", (Object)file);
                        stream = new FileInputStream(file);
                    }
                    if (this.jarCache == null) {
                        this.jarCache = LRUCacheFactory.newLRUSoftCache(1000);
                    }
                    this.loadImplementationsInJar(test, packageName, stream, urlPath, classes, this.jarCache);
                }
                catch (Throwable throwable) {
                    IOHelper.close(stream);
                    throw throwable;
                }
                IOHelper.close((Closeable)stream);
            }
            catch (IOException e) {
                LOG.debug("Cannot read entries in url: {}", (Object)url, (Object)e);
            }
        }
    }

    private PackageScanFilter getCompositeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            CompositePackageScanFilter composite = new CompositePackageScanFilter(this.scanFilters);
            composite.addFilter(filter);
            return composite;
        }
        return filter;
    }

    private void loadImplementationsInDirectory(PackageScanFilter test, String parent, File location, Set<Class<?>> classes) {
        File[] files = location.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String packageOrClass;
            StringBuilder builder = new StringBuilder(100);
            String name = file.getName().trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file, classes);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass, classes);
        }
    }

    private void loadImplementationsInJar(PackageScanFilter test, String parent, InputStream stream, String urlPath, Set<Class<?>> classes, Map<String, List<String>> jarCache) {
        List<String> entries;
        ObjectHelper.notNull(classes, (String)"classes");
        List<String> list = entries = jarCache != null ? jarCache.get(urlPath) : null;
        if (entries == null) {
            entries = this.doLoadJarClassEntries(stream, urlPath);
            if (jarCache != null) {
                jarCache.put(urlPath, entries);
                LOG.trace("Cached {} JAR with {} entries", (Object)urlPath, (Object)entries.size());
            }
        } else {
            LOG.trace("Using cached {} JAR with {} entries", (Object)urlPath, (Object)entries.size());
        }
        this.doLoadImplementationsInJar(test, parent, entries, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> doLoadJarClassEntries(InputStream stream, String urlPath) {
        ArrayList<String> entries = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName().trim();
                if (entry.isDirectory() || !name.endsWith(".class")) continue;
                entries.add(name);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Cannot search jar file '{}' due to an IOException: {}", new Object[]{urlPath, ioe.getMessage(), ioe});
        }
        finally {
            IOHelper.close((Closeable)jarStream, (String)urlPath, (Logger)LOG);
        }
        return entries;
    }

    private void doLoadImplementationsInJar(PackageScanFilter test, String parent, List<String> entries, Set<Class<?>> classes) {
        for (String entry : entries) {
            if (!entry.startsWith(parent)) continue;
            this.addIfMatching(test, entry, classes);
        }
    }

    protected void addIfMatching(PackageScanFilter test, String fqn, Set<Class<?>> classes) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            Set<ClassLoader> set = this.getClassLoaders();
            boolean found = false;
            for (ClassLoader classLoader : set) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Testing for class {} matches criteria [{}] using classloader: {}", new Object[]{externalName, test, classLoader});
                }
                try {
                    Class<?> type = classLoader.loadClass(externalName);
                    LOG.trace("Loaded the class: {} in classloader: {}", type, (Object)classLoader);
                    if (test.matches(type)) {
                        LOG.trace("Found class: {} which matches the filter in classloader: {}", type, (Object)classLoader);
                        classes.add(type);
                    }
                    found = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Cannot find class '{}' in classloader: {}. Reason: {}", new Object[]{fqn, classLoader, e.getMessage(), e});
                }
                catch (NoClassDefFoundError e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Cannot find the class definition '{}' in classloader: {}. Reason: {}", new Object[]{fqn, classLoader, e.getMessage(), e});
                }
            }
            if (!found) {
                LOG.debug("Cannot find class '{}' in any classloaders: {}", (Object)fqn, set);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot examine class '{}' due to a {} with message: {}", new Object[]{fqn, e.getClass().getName(), e.getMessage(), e});
        }
    }

    public void clearCache() {
        if (this.jarCache != null) {
            this.jarCache.clear();
            this.jarCache = null;
        }
    }

    protected void doStop() throws Exception {
        this.clearCache();
    }
}

