/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultMessage
extends MessageSupport {
    private Map<String, Object> headers;

    public DefaultMessage(Exchange exchange) {
        this.setExchange(exchange);
        this.setCamelContext(exchange != null ? exchange.getContext() : null);
    }

    public DefaultMessage(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    public Object getHeader(String name) {
        if (this.hasHeaders()) {
            return this.getHeaders().get(name);
        }
        return null;
    }

    public Object getHeader(String name, Object defaultValue) {
        Object answer = this.getHeaders().get(name);
        return answer != null ? answer : defaultValue;
    }

    public Object getHeader(String name, Supplier<Object> defaultValueSupplier) {
        ObjectHelper.notNull((Object)name, (String)"name");
        ObjectHelper.notNull(defaultValueSupplier, (String)"defaultValueSupplier");
        Object answer = this.getHeaders().get(name);
        return answer != null ? answer : defaultValueSupplier.get();
    }

    public <T> T getHeader(String name, Class<T> type) {
        Object value = this.getHeader(name);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return (T)e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    public <T> T getHeader(String name, Object defaultValue, Class<T> type) {
        Object value = this.getHeader(name, defaultValue);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return (T)e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    public <T> T getHeader(String name, Supplier<Object> defaultValueSupplier, Class<T> type) {
        ObjectHelper.notNull((Object)name, (String)"name");
        ObjectHelper.notNull(type, (String)"type");
        ObjectHelper.notNull(defaultValueSupplier, (String)"defaultValueSupplier");
        Object value = this.getHeader(name, defaultValueSupplier);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return (T)e.getContext().getTypeConverter().convertTo(type, e, value);
        }
        return type.cast(value);
    }

    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        this.headers.put(name, value);
    }

    public Object removeHeader(String name) {
        if (!this.hasHeaders()) {
            return null;
        }
        return this.headers.remove(name);
    }

    public boolean removeHeaders(String pattern) {
        return this.removeHeaders(pattern, null);
    }

    public boolean removeHeaders(String pattern, String ... excludePatterns) {
        if (!this.hasHeaders()) {
            return false;
        }
        boolean matches = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            toRemove.add(entry.getKey());
        }
        for (String key : toRemove) {
            this.headers.remove(key);
        }
        return matches;
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)this);
        this.headers = this.getCamelContext().getHeadersMapFactory().isInstanceOf(headers) ? headers : this.getCamelContext().getHeadersMapFactory().newMap(headers);
    }

    public boolean hasHeaders() {
        if (!this.hasPopulatedHeaders()) {
            this.getHeaders();
        }
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public DefaultMessage newInstance() {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)this);
        return new DefaultMessage(this.getCamelContext());
    }

    protected Map<String, Object> createHeaders() {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)this);
        Map map = this.getCamelContext().getHeadersMapFactory().newMap();
        this.populateInitialHeaders(map);
        return map;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
    }

    protected Boolean isTransactedRedelivered() {
        return null;
    }

    protected boolean hasPopulatedHeaders() {
        return this.headers != null;
    }
}

