/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.verifier;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.ComponentAware;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.CatalogVerifierCustomizer;
import org.apache.camel.component.extension.verifier.NoSuchOptionException;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.runtimecatalog.EndpointValidationResult;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StreamUtils;

public class DefaultComponentVerifierExtension
implements ComponentVerifierExtension,
CamelContextAware,
ComponentAware {
    private final String defaultScheme;
    private Component component;
    private CamelContext camelContext;

    protected DefaultComponentVerifierExtension(String defaultScheme) {
        this(defaultScheme, null, null);
    }

    protected DefaultComponentVerifierExtension(String defaultScheme, CamelContext camelContext) {
        this(defaultScheme, camelContext, null);
    }

    protected DefaultComponentVerifierExtension(String defaultScheme, CamelContext camelContext, Component component) {
        this.defaultScheme = defaultScheme;
        this.camelContext = camelContext;
        this.component = component;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public ComponentVerifierExtension.Result verify(ComponentVerifierExtension.Scope scope, Map<String, Object> parameters) {
        if (this.camelContext == null) {
            return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.ERROR, scope).error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.INTERNAL, "Missing camel-context").build()).build();
        }
        if (scope == ComponentVerifierExtension.Scope.PARAMETERS) {
            return this.verifyParameters(parameters);
        }
        if (scope == ComponentVerifierExtension.Scope.CONNECTIVITY) {
            return this.verifyConnectivity(parameters);
        }
        return ResultBuilder.unsupportedScope(scope).build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.UNSUPPORTED, ComponentVerifierExtension.Scope.CONNECTIVITY).build();
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS);
        this.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected void verifyParametersAgainstCatalog(ResultBuilder builder, Map<String, Object> parameters) {
        this.verifyParametersAgainstCatalog(builder, parameters, new CatalogVerifierCustomizer());
    }

    protected void verifyParametersAgainstCatalog(ResultBuilder builder, Map<String, Object> parameters, CatalogVerifierCustomizer customizer) {
        RuntimeCamelCatalog catalog;
        EndpointValidationResult result;
        String scheme = this.defaultScheme;
        if (parameters.containsKey("scheme")) {
            scheme = parameters.get("scheme").toString();
        }
        if (!(result = (catalog = (RuntimeCamelCatalog)this.camelContext.getExtension(RuntimeCamelCatalog.class)).validateProperties(scheme, parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)this.camelContext.getTypeConverter().convertTo(String.class, e.getValue()))))).isSuccess()) {
            if (customizer.isIncludeUnknown()) {
                StreamUtils.stream((Collection)result.getUnknown()).map(option -> ResultErrorBuilder.withUnknownOption(option).build()).forEach(builder::error);
            }
            if (customizer.isIncludeRequired()) {
                StreamUtils.stream((Collection)result.getRequired()).map(option -> ResultErrorBuilder.withMissingOption(option).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidBoolean()) {
                StreamUtils.stream((Map)result.getInvalidBoolean()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidInteger()) {
                StreamUtils.stream((Map)result.getInvalidInteger()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidNumber()) {
                StreamUtils.stream((Map)result.getInvalidNumber()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidEnum()) {
                StreamUtils.stream((Map)result.getInvalidEnum()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).detail("enum.values", (Object)result.getEnumChoices((String)entry.getKey())).build()).forEach(builder::error);
            }
        }
    }

    protected <T> T setProperties(T instance, Map<String, Object> properties) throws Exception {
        if (this.camelContext == null) {
            throw new IllegalStateException("Camel context is null");
        }
        if (!properties.isEmpty()) {
            PropertyBindingSupport.build().bind(this.camelContext, instance, properties);
        }
        return instance;
    }

    protected <T> T setProperties(T instance, String prefix, Map<String, Object> properties) throws Exception {
        return this.setProperties(instance, PropertiesHelper.extractProperties(properties, (String)prefix, (boolean)false));
    }

    protected <T> Optional<T> getOption(Map<String, Object> parameters, String key, Class<T> type) {
        Object value = parameters.get(key);
        if (value != null) {
            return Optional.ofNullable(CamelContextHelper.convertTo(this.camelContext, type, value));
        }
        return Optional.empty();
    }

    protected <T> T getOption(Map<String, Object> parameters, String key, Class<T> type, Supplier<T> defaultSupplier) {
        return this.getOption(parameters, key, type).orElseGet(defaultSupplier);
    }

    protected <T> T getMandatoryOption(Map<String, Object> parameters, String key, Class<T> type) throws NoSuchOptionException {
        return this.getOption(parameters, key, type).orElseThrow(() -> new NoSuchOptionException(key));
    }
}

