/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntrospectionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(IntrospectionSupport.class);
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private static final Map<Class<?>, ClassInfo> CACHE = LRUCacheFactory.newLRUWeakCache(1000);
    private static final Object LOCK = new Object();
    private static final Pattern SECRETS = Pattern.compile(".*(passphrase|password|secretKey).*", 2);
    private static final Set<Class<?>> PRIMITIVE_CLASSES;

    private IntrospectionSupport() {
    }

    public static void stop() {
        if (LOG.isDebugEnabled() && CACHE instanceof LRUCache) {
            LRUCache localCache = (LRUCache)CACHE;
            LOG.debug("Clearing cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{localCache.size(), localCache.getHits(), localCache.getMisses(), localCache.getEvicted()});
        }
        CACHE.clear();
        Introspector.flushCaches();
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        int parameterCount = method.getParameterCount();
        if (name.startsWith("get") && name.length() >= 4 && Character.isUpperCase(name.charAt(3))) {
            return parameterCount == 0 && !type.equals(Void.TYPE);
        }
        if (name.startsWith("is") && name.length() >= 3 && Character.isUpperCase(name.charAt(2))) {
            return parameterCount == 0 && type.getSimpleName().equalsIgnoreCase("boolean");
        }
        return false;
    }

    public static String getGetterShorthandName(Method method) {
        if (!IntrospectionSupport.isGetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public static String getSetterShorthandName(Method method) {
        if (!IntrospectionSupport.isSetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("set")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public static boolean isSetter(Method method, boolean allowBuilderPattern) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        int parameterCount = method.getParameterCount();
        if (name.startsWith("set") && name.length() >= 4 && Character.isUpperCase(name.charAt(3))) {
            return parameterCount == 1 && (type.equals(Void.TYPE) || allowBuilderPattern && method.getDeclaringClass().isAssignableFrom(type));
        }
        return false;
    }

    public static boolean isSetter(Method method) {
        return IntrospectionSupport.isSetter(method, false);
    }

    public static Map<String, Object> getNonNullProperties(Object target) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(target, properties, null, false);
        return properties;
    }

    public static boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix) {
        return IntrospectionSupport.getProperties(target, properties, optionPrefix, true);
    }

    public static boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix, boolean includeNull) {
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        ClassInfo cache = IntrospectionSupport.cacheClass(target.getClass());
        for (MethodInfo info : cache.methods) {
            Method method = info.method;
            if (!info.isGetter.booleanValue() || !info.hasGetterAndSetter.booleanValue()) continue;
            String name = info.getterOrSetterShorthandName;
            try {
                method.setAccessible(true);
                Object value = method.invoke(target, new Object[0]);
                if (value == null && !includeNull) continue;
                properties.put(optionPrefix + name, value);
                rc = true;
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Error invoking getter method " + method + ". This exception is ignored.", (Throwable)e);
            }
        }
        return rc;
    }

    public static ClassInfo cacheClass(Class<?> clazz) {
        ClassInfo cache = CACHE.get(clazz);
        if (cache == null) {
            cache = IntrospectionSupport.doIntrospectClass(clazz);
            CACHE.put(clazz, cache);
        }
        return cache;
    }

    private static ClassInfo doIntrospectClass(Class<?> clazz) {
        ClassInfo answer = new ClassInfo();
        answer.clazz = clazz;
        ArrayList<MethodInfo> found = new ArrayList<MethodInfo>();
        Method[] methods = clazz.getMethods();
        HashMap<String, MethodInfo> getters = new HashMap<String, MethodInfo>(methods.length);
        HashMap<String, MethodInfo> setters = new HashMap<String, MethodInfo>(methods.length);
        for (Method method : methods) {
            if (EXCLUDED_METHODS.contains(method)) continue;
            MethodInfo cache = new MethodInfo();
            cache.method = method;
            if (IntrospectionSupport.isGetter(method)) {
                cache.isGetter = true;
                cache.isSetter = false;
                cache.getterOrSetterShorthandName = IntrospectionSupport.getGetterShorthandName(method);
                getters.put(cache.getterOrSetterShorthandName, cache);
            } else if (IntrospectionSupport.isSetter(method)) {
                cache.isGetter = false;
                cache.isSetter = true;
                cache.getterOrSetterShorthandName = IntrospectionSupport.getSetterShorthandName(method);
                setters.put(cache.getterOrSetterShorthandName, cache);
            } else {
                cache.isGetter = false;
                cache.isSetter = false;
            }
            found.add(cache);
        }
        for (MethodInfo info : found) {
            info.hasGetterAndSetter = false;
            if (info.isGetter.booleanValue()) {
                info.hasGetterAndSetter = setters.containsKey(info.getterOrSetterShorthandName);
                continue;
            }
            if (!info.isSetter.booleanValue()) continue;
            info.hasGetterAndSetter = getters.containsKey(info.getterOrSetterShorthandName);
        }
        answer.methods = found.toArray(new MethodInfo[found.size()]);
        return answer;
    }

    public static boolean hasProperties(Map<String, Object> properties, String optionPrefix) {
        ObjectHelper.notNull(properties, (String)"properties");
        if (ObjectHelper.isNotEmpty((Object)optionPrefix)) {
            for (String o : properties.keySet()) {
                String name = o;
                if (!name.startsWith(optionPrefix)) continue;
                return true;
            }
            return false;
        }
        return !properties.isEmpty();
    }

    public static Object getProperty(Object target, String property) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull((Object)property, (String)"property");
        property = property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
        Class<?> clazz = target.getClass();
        Method method = IntrospectionSupport.getPropertyGetter(clazz, property);
        return method.invoke(target, new Object[0]);
    }

    public static Object getOrElseProperty(Object target, String property, Object defaultValue) {
        try {
            return IntrospectionSupport.getProperty(target, property);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Method getPropertyGetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        if (IntrospectionSupport.isPropertyIsGetter(type, propertyName)) {
            return type.getMethod("is" + StringHelper.capitalize((String)propertyName, (boolean)true), new Class[0]);
        }
        return type.getMethod("get" + StringHelper.capitalize((String)propertyName, (boolean)true), new Class[0]);
    }

    public static Method getPropertySetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        String name = "set" + StringHelper.capitalize((String)propertyName, (boolean)true);
        for (Method method : type.getMethods()) {
            if (!IntrospectionSupport.isSetter(method) || !method.getName().equals(name)) continue;
            return method;
        }
        throw new NoSuchMethodException(type.getCanonicalName() + "." + name);
    }

    public static boolean isPropertyIsGetter(Class<?> type, String propertyName) {
        try {
            Method method = type.getMethod("is" + StringHelper.capitalize((String)propertyName, (boolean)true), new Class[0]);
            if (method != null) {
                return method.getReturnType().isAssignableFrom(Boolean.TYPE) || method.getReturnType().isAssignableFrom(Boolean.class);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static boolean setProperties(Object target, Map<String, Object> properties, String optionPrefix, boolean allowBuilderPattern) throws Exception {
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey().toString();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value, allowBuilderPattern)) continue;
            it.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map<String, Object> properties, String optionPrefix) throws Exception {
        StringHelper.notEmpty((String)optionPrefix, (String)"optionPrefix");
        return IntrospectionSupport.setProperties(target, properties, optionPrefix, false);
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        return IntrospectionSupport.extractProperties(properties, optionPrefix, true);
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix, boolean remove) {
        ObjectHelper.notNull(properties, (String)"properties");
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            if (!remove) continue;
            it.remove();
        }
        return rc;
    }

    public static Map<String, String> extractStringProperties(Map<String, Object> properties) {
        ObjectHelper.notNull(properties, (String)"properties");
        LinkedHashMap<String, String> rc = new LinkedHashMap<String, String>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue().toString();
            rc.put(name, value);
        }
        return rc;
    }

    public static boolean setProperties(CamelContext context, TypeConverter typeConverter, Object target, Map<String, Object> properties) throws Exception {
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            if (!IntrospectionSupport.setProperty(context, typeConverter, target, entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperties(TypeConverter typeConverter, Object target, Map<String, Object> properties) throws Exception {
        return IntrospectionSupport.setProperties(null, typeConverter, target, properties);
    }

    public static boolean setProperties(Object target, Map<String, Object> properties) throws Exception {
        return IntrospectionSupport.setProperties(null, target, properties);
    }

    public static boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value, String refName, boolean allowBuilderPattern) throws Exception {
        Class<?> clazz = target.getClass();
        Collection<Method> setters = context != null && refName != null && value == null ? IntrospectionSupport.findSetterMethodsOrderedByParameterType(clazz, name, allowBuilderPattern) : IntrospectionSupport.findSetterMethods(clazz, name, value, allowBuilderPattern);
        if (setters.isEmpty()) {
            return false;
        }
        Throwable typeConversionFailed = null;
        for (Method setter : setters) {
            boolean assignable;
            String s;
            Class<?> parameterType = setter.getParameterTypes()[0];
            Object ref = value;
            if (context != null && refName != null && ref == null && ((ref = CamelContextHelper.lookup(context, s = StringHelper.replaceAll((String)refName, (String)"#", (String)""))) == null || !(assignable = ObjectHelper.isAssignableFrom(parameterType, ref.getClass())))) continue;
            try {
                try {
                    if (value == null || ObjectHelper.isAssignableFrom(parameterType, ref.getClass())) {
                        setter.setAccessible(true);
                        setter.invoke(target, ref);
                        if (LOG.isTraceEnabled()) {
                            String val;
                            String string = val = ref != null ? ref.toString() : "";
                            if (SECRETS.matcher(name).find()) {
                                val = "xxxxxx";
                            }
                            LOG.trace("Configured property: {} on bean: {} with value: {}", new Object[]{name, target, val});
                        }
                        return true;
                    }
                    Object convertedValue = IntrospectionSupport.convert(typeConverter, parameterType, ref);
                    setter.setAccessible(true);
                    setter.invoke(target, convertedValue);
                    if (LOG.isTraceEnabled()) {
                        String val;
                        String string = val = ref != null ? ref.toString() : "";
                        if (SECRETS.matcher(name).find()) {
                            val = "xxxxxx";
                        }
                        LOG.trace("Configured property: {} on bean: {} with value: {}", new Object[]{name, target, val});
                    }
                    return true;
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw exception;
                    }
                    Error error = (Error)throwable;
                    throw error;
                }
            }
            catch (SecurityException e) {
                typeConversionFailed = e;
            }
            catch (NoTypeConversionAvailableException e) {
                typeConversionFailed = e;
            }
            catch (IllegalArgumentException e) {
                typeConversionFailed = e;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Setter \"{}\" with parameter type \"{}\" could not be used for type conversions of {}", new Object[]{setter, parameterType, ref});
        }
        if (typeConversionFailed != null && !IntrospectionSupport.isPropertyPlaceholder(context, value)) {
            throw new IllegalArgumentException("Could not find a suitable setter for property: " + name + " as there isn't a setter method with same type: " + (value != null ? value.getClass().getCanonicalName() : "[null]") + " nor type conversion possible: " + typeConversionFailed.getMessage());
        }
        return false;
    }

    private static boolean isPropertyPlaceholder(CamelContext context, Object value) {
        PropertiesComponent pc;
        if (context != null && (pc = context.getPropertiesComponent(false)) != null) {
            return value.toString().contains(pc.getPrefixToken()) && value.toString().contains(pc.getSuffixToken());
        }
        return false;
    }

    public static boolean setProperty(CamelContext context, Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(context, context != null ? context.getTypeConverter() : null, target, name, value, null, true);
    }

    public static boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(context, typeConverter, target, name, value, null, true);
    }

    public static boolean setProperty(TypeConverter typeConverter, Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(null, typeConverter, target, name, value, null, true);
    }

    public static boolean setProperty(Object target, String name, Object value, boolean allowBuilderPattern) throws Exception {
        return IntrospectionSupport.setProperty(null, null, target, name, value, null, allowBuilderPattern);
    }

    public static boolean setProperty(Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(target, name, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object convert(TypeConverter typeConverter, Class<?> type, Object value) throws URISyntaxException, NoTypeConversionAvailableException {
        if (typeConverter != null) {
            return typeConverter.mandatoryConvertTo(type, value);
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            Object answer;
            Object object = LOCK;
            synchronized (object) {
                editor.setAsText(value.toString());
                answer = editor.getValue();
            }
            return answer;
        }
        return null;
    }

    public static Set<Method> findSetterMethods(Class<?> clazz, String name, boolean allowBuilderPattern) {
        LinkedHashSet<Method> candidates = new LinkedHashSet<Method>();
        name = "set" + StringHelper.capitalize((String)name, (boolean)true);
        while (clazz != Object.class) {
            Method[] methods;
            Method objectSetMethod = null;
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getName().equals(name) || !IntrospectionSupport.isSetter(method, allowBuilderPattern)) continue;
                Class<?>[] params = method.getParameterTypes();
                if (params[0].equals(Object.class)) {
                    objectSetMethod = method;
                    continue;
                }
                candidates.add(method);
            }
            if (objectSetMethod != null) {
                candidates.add(objectSetMethod);
            }
            clazz = clazz.getSuperclass();
        }
        return candidates;
    }

    private static Set<Method> findSetterMethods(Class<?> clazz, String name, Object value, boolean allowBuilderPattern) {
        Set<Method> candidates = IntrospectionSupport.findSetterMethods(clazz, name, allowBuilderPattern);
        if (candidates.isEmpty()) {
            return candidates;
        }
        if (candidates.size() == 1) {
            return candidates;
        }
        LOG.trace("Found {} suitable setter methods for setting {}", (Object)candidates.size(), (Object)name);
        for (Method method : candidates) {
            if (!method.getParameterTypes()[0].isInstance(value)) continue;
            LOG.trace("Method {} is the best candidate as it has parameter with same instance type", (Object)method);
            candidates.clear();
            candidates.add(method);
            return candidates;
        }
        return candidates;
    }

    protected static List<Method> findSetterMethodsOrderedByParameterType(Class<?> target, String propertyName, boolean allowBuilderPattern) {
        LinkedList<Method> answer = new LinkedList<Method>();
        LinkedList<Method> primitives = new LinkedList<Method>();
        Set<Method> setters = IntrospectionSupport.findSetterMethods(target, propertyName, allowBuilderPattern);
        for (Method setter : setters) {
            Class<?> parameterType = setter.getParameterTypes()[0];
            if (PRIMITIVE_CLASSES.contains(parameterType)) {
                primitives.add(setter);
                continue;
            }
            answer.add(setter);
        }
        answer.addAll(primitives);
        return answer;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getMethods()));
        PRIMITIVE_CLASSES = new HashSet();
        PRIMITIVE_CLASSES.add(String.class);
        PRIMITIVE_CLASSES.add(Character.class);
        PRIMITIVE_CLASSES.add(Boolean.class);
        PRIMITIVE_CLASSES.add(Byte.class);
        PRIMITIVE_CLASSES.add(Short.class);
        PRIMITIVE_CLASSES.add(Integer.class);
        PRIMITIVE_CLASSES.add(Long.class);
        PRIMITIVE_CLASSES.add(Float.class);
        PRIMITIVE_CLASSES.add(Double.class);
        PRIMITIVE_CLASSES.add(Character.TYPE);
        PRIMITIVE_CLASSES.add(Boolean.TYPE);
        PRIMITIVE_CLASSES.add(Byte.TYPE);
        PRIMITIVE_CLASSES.add(Short.TYPE);
        PRIMITIVE_CLASSES.add(Integer.TYPE);
        PRIMITIVE_CLASSES.add(Long.TYPE);
        PRIMITIVE_CLASSES.add(Float.TYPE);
        PRIMITIVE_CLASSES.add(Double.TYPE);
    }

    public static final class MethodInfo {
        public Method method;
        public Boolean isGetter;
        public Boolean isSetter;
        public String getterOrSetterShorthandName;
        public Boolean hasGetterAndSetter;
    }

    public static final class ClassInfo {
        public Class<?> clazz;
        public MethodInfo[] methods;
    }
}

