/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.stored.SqlStoredEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;
import org.springframework.jdbc.core.JdbcTemplate;

@Component(value="sql-stored")
public class SqlStoredComponent
extends DefaultComponent {
    @Metadata(autowired=true)
    private DataSource dataSource;
    @Metadata(label="advanced", description="Whether to detect the network address location of the JMS broker on startup. This information is gathered via reflection on the ConnectionFactory, and is vendor specific. This option can be used to turn this off.", defaultValue="true")
    private boolean serviceLocationEnabled = true;

    protected Endpoint createEndpoint(String uri, String template, Map<String, Object> parameters) throws Exception {
        SqlStoredEndpoint endpoint = new SqlStoredEndpoint(uri, this);
        endpoint.setServiceLocationEnabled(this.serviceLocationEnabled);
        endpoint.setTemplate(template);
        this.setProperties((Endpoint)endpoint, parameters);
        DataSource ds = this.dataSource;
        if (endpoint.getDataSource() != null) {
            ds = endpoint.getDataSource();
        }
        if (ds == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(ds);
        Map templateOptions = PropertiesHelper.extractProperties(parameters, (String)"template.");
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)jdbcTemplate, (Map)templateOptions);
        endpoint.setJdbcTemplate(jdbcTemplate);
        endpoint.setDataSource(ds);
        endpoint.setTemplateOptions(templateOptions);
        return endpoint;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isServiceLocationEnabled() {
        return this.serviceLocationEnabled;
    }

    public void setServiceLocationEnabled(boolean serviceLocationEnabled) {
        this.serviceLocationEnabled = serviceLocationEnabled;
    }
}

