/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.jdbc.JdbcAggregationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ClusteredJdbcAggregationRepository
extends JdbcAggregationRepository {
    private static final String INSTANCE_ID = "instance_id";
    private static final Logger LOG = LoggerFactory.getLogger(ClusteredJdbcAggregationRepository.class);
    private String instanceId = "DEFAULT";
    private boolean recoveryByInstance;

    public ClusteredJdbcAggregationRepository() {
    }

    public ClusteredJdbcAggregationRepository(PlatformTransactionManager transactionManager, String repositoryName, DataSource dataSource) {
        this.setRepositoryName(repositoryName);
        this.setTransactionManager(transactionManager);
        this.setDataSource(dataSource);
    }

    @Override
    public void remove(final CamelContext camelContext, final String correlationId, final Exchange exchange) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                String confirmKey = exchange.getExchangeId();
                long version = (Long)exchange.getProperty("CamelOptimisticLockVersion", Long.class);
                try {
                    LOG.debug("Removing key {}", (Object)correlationId);
                    ClusteredJdbcAggregationRepository.this.jdbcTemplate.update("DELETE FROM " + ClusteredJdbcAggregationRepository.this.getRepositoryName() + " WHERE id = ? AND version = ?", new Object[]{correlationId, version});
                    ClusteredJdbcAggregationRepository.this.insert(camelContext, confirmKey, exchange, ClusteredJdbcAggregationRepository.this.getRepositoryNameCompleted(), version, true);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error removing key " + correlationId + " from repository " + ClusteredJdbcAggregationRepository.this.getRepositoryName(), e);
                }
            }
        });
    }

    protected void insert(CamelContext camelContext, String correlationId, Exchange exchange, String repositoryName, Long version, boolean completed) throws Exception {
        int totalParameterIndex = 3;
        StringBuilder queryBuilder = new StringBuilder(256).append("INSERT INTO ").append(repositoryName).append('(').append("exchange").append(", ").append("id").append(", ").append("version");
        if (this.isStoreBodyAsText()) {
            queryBuilder.append(", ").append("body");
            ++totalParameterIndex;
        }
        if (this.hasHeadersToStoreAsText()) {
            for (String headerName : this.getHeadersToStoreAsText()) {
                queryBuilder.append(", ").append(headerName);
                ++totalParameterIndex;
            }
        }
        if (completed && this.isRecoveryByInstance()) {
            queryBuilder.append(", ").append(INSTANCE_ID);
            ++totalParameterIndex;
        }
        queryBuilder.append(") VALUES (");
        queryBuilder.append("?, ".repeat(totalParameterIndex - 1));
        queryBuilder.append("?)");
        String sql = queryBuilder.toString();
        this.insertHelper(camelContext, correlationId, exchange, sql, version, completed);
    }

    protected int insertHelper(CamelContext camelContext, final String key, final Exchange exchange, String sql, final Long version, final boolean completed) throws Exception {
        final byte[] data = this.jdbcCamelCodec.marshallExchange(exchange, this.isAllowSerializedHeaders());
        Integer insertCount = (Integer)this.jdbcTemplate.execute(sql, (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback(this.getLobHandler()){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                int totalParameterIndex = 0;
                lobCreator.setBlobAsBytes(ps, ++totalParameterIndex, data);
                ps.setString(++totalParameterIndex, key);
                ps.setLong(++totalParameterIndex, version);
                if (ClusteredJdbcAggregationRepository.this.isStoreBodyAsText()) {
                    ps.setString(++totalParameterIndex, (String)exchange.getIn().getBody(String.class));
                }
                if (ClusteredJdbcAggregationRepository.this.hasHeadersToStoreAsText()) {
                    for (String headerName : ClusteredJdbcAggregationRepository.this.getHeadersToStoreAsText()) {
                        String headerValue = (String)exchange.getIn().getHeader(headerName, String.class);
                        ps.setString(++totalParameterIndex, headerValue);
                    }
                }
                if (completed && ClusteredJdbcAggregationRepository.this.isRecoveryByInstance()) {
                    ps.setString(++totalParameterIndex, ClusteredJdbcAggregationRepository.this.instanceId);
                }
            }
        });
        return insertCount == null ? 0 : insertCount;
    }

    @Override
    public Set<String> scan(CamelContext camelContext) {
        return (Set)this.transactionTemplateReadOnly.execute((TransactionCallback)new TransactionCallback<LinkedHashSet<String>>(){

            public LinkedHashSet<String> doInTransaction(TransactionStatus status) {
                List keys = ClusteredJdbcAggregationRepository.this.jdbcTemplate.query("SELECT id FROM " + ClusteredJdbcAggregationRepository.this.getRepositoryNameCompleted() + (String)(ClusteredJdbcAggregationRepository.this.isRecoveryByInstance() ? " WHERE INSTANCE_ID='" + ClusteredJdbcAggregationRepository.this.instanceId + "'" : ""), (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        String id = rs.getString("id");
                        LOG.trace("getKey {}", (Object)id);
                        return id;
                    }
                });
                return new LinkedHashSet<String>(keys);
            }
        });
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean isRecoveryByInstance() {
        return this.recoveryByInstance;
    }

    public void setRecoveryByInstance(boolean recoveryByInstance) {
        this.recoveryByInstance = recoveryByInstance;
    }
}

