/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.processor.aggregate.jdbc.ClassLoadingAwareObjectInputStream;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.util.IOHelper;

public class JdbcCamelCodec {
    public byte[] marshallExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        this.marshallExchange(camelContext, exchange, allowSerializedHeaders, bytesOut);
        return bytesOut.toByteArray();
    }

    public void marshallExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders, OutputStream outputStream) throws IOException {
        DefaultExchangeHolder pe = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)false, (boolean)allowSerializedHeaders);
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedSize", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_SIZE, Integer.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedTimeout", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_TIMEOUT, Long.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCompletedBy", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_COMPLETED_BY, String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_CORRELATION_KEY, String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_CORRELATION_KEY, String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCollectionGuard", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCollectionGuard", String.class)));
        if (exchange.getFromEndpoint() != null) {
            DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedFromEndpoint", (Serializable)((Object)exchange.getFromEndpoint().getEndpointUri()));
        }
        this.encode(pe, outputStream);
    }

    public Exchange unmarshallExchange(CamelContext camelContext, byte[] buffer) throws IOException, ClassNotFoundException {
        return this.unmarshallExchange(camelContext, new ByteArrayInputStream(buffer));
    }

    public Exchange unmarshallExchange(CamelContext camelContext, InputStream inputStream) throws IOException, ClassNotFoundException {
        Endpoint fromEndpoint;
        DefaultExchangeHolder pe = this.decode(camelContext, inputStream);
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal((Exchange)answer, (DefaultExchangeHolder)pe);
        String fromEndpointUri = (String)answer.removeProperty("CamelAggregatedFromEndpoint");
        if (fromEndpointUri != null && (fromEndpoint = camelContext.hasEndpoint(fromEndpointUri)) != null) {
            ((ExtendedExchange)answer.adapt(ExtendedExchange.class)).setFromEndpoint(fromEndpoint);
        }
        return answer;
    }

    private void encode(Object object, OutputStream bytesOut) throws IOException {
        try (ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);){
            objectOut.writeObject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultExchangeHolder decode(CamelContext camelContext, InputStream bytesIn) throws IOException, ClassNotFoundException {
        ClassLoadingAwareObjectInputStream objectIn = null;
        Object obj = null;
        try {
            objectIn = new ClassLoadingAwareObjectInputStream(camelContext, bytesIn);
            obj = objectIn.readObject();
        }
        catch (Throwable throwable) {
            IOHelper.close(objectIn);
            throw throwable;
        }
        IOHelper.close((Closeable)objectIn);
        return (DefaultExchangeHolder)obj;
    }
}

