/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.DelayPolicy;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionInterceptor
extends DelegateProcessor {
    public static final ExchangeProperty<Boolean> TRANSACTED = new ExchangeProperty("transacted", "org.apache.camel.transacted", Boolean.class);
    private static final transient Log LOG = LogFactory.getLog(TransactionInterceptor.class);
    private final TransactionTemplate transactionTemplate;
    private RedeliveryPolicy redeliveryPolicy;
    private DelayPolicy delayPolicy;

    public TransactionInterceptor(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public TransactionInterceptor(Processor processor, TransactionTemplate transactionTemplate) {
        super(processor);
        this.transactionTemplate = transactionTemplate;
    }

    public TransactionInterceptor(Processor processor, TransactionTemplate transactionTemplate, RedeliveryPolicy redeliveryPolicy) {
        this(processor, transactionTemplate);
        this.redeliveryPolicy = redeliveryPolicy;
        this.delayPolicy = redeliveryPolicy;
    }

    public TransactionInterceptor(Processor processor, TransactionTemplate transactionTemplate, DelayPolicy delayPolicy) {
        this(processor, transactionTemplate);
        this.delayPolicy = delayPolicy;
    }

    public String toString() {
        return "TransactionInterceptor:" + this.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getProcessor() + "]";
    }

    public void process(final Exchange exchange) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                RuntimeCamelException rce = null;
                boolean activeTx = false;
                try {
                    activeTx = TransactionSynchronizationManager.isActualTransactionActive();
                    if (!activeTx) {
                        boolean bl = activeTx = status.isNewTransaction() && !status.isCompleted();
                        if (!activeTx && DefaultTransactionStatus.class.isAssignableFrom(status.getClass())) {
                            DefaultTransactionStatus defStatus = (DefaultTransactionStatus)DefaultTransactionStatus.class.cast(status);
                            boolean bl2 = activeTx = defStatus.hasTransaction() && !status.isCompleted();
                        }
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Is actual transaction active: " + activeTx));
                    }
                    if (activeTx) {
                        TRANSACTED.set(exchange, (Object)Boolean.TRUE);
                    }
                    TransactionInterceptor.this.processNext(exchange);
                    if (exchange.getException() != null) {
                        rce = ObjectHelper.wrapRuntimeCamelException((Throwable)exchange.getException());
                    }
                }
                catch (Exception e) {
                    rce = ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
                if (rce != null) {
                    TransactionInterceptor.this.delayBeforeRedelivery();
                    if (activeTx) {
                        status.setRollbackOnly();
                        LOG.debug((Object)("Setting transaction to rollbackOnly due to exception being thrown: " + rce.getMessage()));
                    }
                    throw rce;
                }
            }
        });
    }

    protected void delayBeforeRedelivery() {
        block7: {
            long delay = 0L;
            if (this.redeliveryPolicy != null) {
                delay = this.redeliveryPolicy.getDelay();
            } else if (this.delayPolicy != null) {
                delay = this.delayPolicy.getDelay();
            }
            if (delay > 0L) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Sleeping for: " + delay + " millis until attempting redelivery"));
                    }
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)("Thread interrupted: " + e), (Throwable)e);
                }
            }
        }
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public DelayPolicy getDelayPolicy() {
        return this.delayPolicy;
    }

    public void setDelayPolicy(DelayPolicy delayPolicy) {
        this.delayPolicy = delayPolicy;
    }

    protected String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKNOWN";
            }
        }
        return rc;
    }
}

