/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.handler.CamelNamespaceHandler;
import org.apache.camel.util.MainSupport;
import org.apache.camel.view.ModelFileGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends MainSupport {
    private static Main instance;
    private String applicationContextUri = "META-INF/spring/*.xml";
    private String fileApplicationContextUri;
    private AbstractApplicationContext applicationContext;
    private AbstractApplicationContext parentApplicationContext;
    private String parentApplicationContextUri;

    public Main() {
        this.addOption((MainSupport.Option)new MainSupport.ParameterOption("ac", "applicationContext", "Sets the classpath based spring ApplicationContext", "applicationContext"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setApplicationContextUri(parameter);
            }
        });
        this.addOption((MainSupport.Option)new MainSupport.ParameterOption("fa", "fileApplicationContext", "Sets the filesystem based spring ApplicationContext", "fileApplicationContext"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setFileApplicationContextUri(parameter);
            }
        });
    }

    public static void main(String ... args) {
        Main main;
        instance = main = new Main();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    public void enableDebug() {
        super.enableDebug();
        this.setParentApplicationContextUri("/META-INF/services/org/apache/camel/spring/debug.xml");
    }

    public void enableTrace() {
        super.enableTrace();
        this.setParentApplicationContextUri("/META-INF/services/org/apache/camel/spring/trace.xml");
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    public String getFileApplicationContextUri() {
        return this.fileApplicationContextUri;
    }

    public void setFileApplicationContextUri(String fileApplicationContextUri) {
        this.fileApplicationContextUri = fileApplicationContextUri;
    }

    public AbstractApplicationContext getParentApplicationContext() {
        if (this.parentApplicationContext == null && this.parentApplicationContextUri != null) {
            this.parentApplicationContext = new ClassPathXmlApplicationContext(this.parentApplicationContextUri);
            this.parentApplicationContext.start();
        }
        return this.parentApplicationContext;
    }

    public void setParentApplicationContext(AbstractApplicationContext parentApplicationContext) {
        this.parentApplicationContext = parentApplicationContext;
    }

    public String getParentApplicationContextUri() {
        return this.parentApplicationContextUri;
    }

    public void setParentApplicationContextUri(String parentApplicationContextUri) {
        this.parentApplicationContextUri = parentApplicationContextUri;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.applicationContext == null) {
            this.applicationContext = this.createDefaultApplicationContext();
        }
        this.applicationContext.start();
        this.postProcessContext();
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        String[] names = this.getApplicationContext().getBeanNamesForType(ProducerTemplate.class);
        if (names != null && names.length > 0) {
            return (ProducerTemplate)this.getApplicationContext().getBean(names[0], ProducerTemplate.class);
        }
        Iterator i$ = this.getCamelContexts().iterator();
        if (i$.hasNext()) {
            CamelContext camelContext = (CamelContext)i$.next();
            return camelContext.createProducerTemplate();
        }
        throw new IllegalArgumentException("No CamelContexts are available so cannot create a ProducerTemplate!");
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        if (this.getFileApplicationContextUri() != null) {
            String[] args = this.getFileApplicationContextUri().split(";");
            AbstractApplicationContext parentContext = this.getParentApplicationContext();
            if (parentContext != null) {
                return new FileSystemXmlApplicationContext(args, (ApplicationContext)parentContext);
            }
            return new FileSystemXmlApplicationContext(args);
        }
        String[] args = this.getApplicationContextUri().split(";");
        AbstractApplicationContext parentContext = this.getParentApplicationContext();
        if (parentContext != null) {
            return new ClassPathXmlApplicationContext(args, (ApplicationContext)parentContext);
        }
        return new ClassPathXmlApplicationContext(args);
    }

    protected void doStop() throws Exception {
        LOG.info((Object)"Apache Camel terminating");
        if (this.applicationContext != null) {
            this.applicationContext.close();
        }
    }

    protected Map<String, CamelContext> getCamelContextMap() {
        Map map = this.applicationContext.getBeansOfType(SpringCamelContext.class);
        Set entries = map.entrySet();
        HashMap<String, CamelContext> answer = new HashMap<String, CamelContext>();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            CamelContext camelContext = (CamelContext)entry.getValue();
            answer.put(name, camelContext);
        }
        return answer;
    }

    protected ModelFileGenerator createModelFileGenerator() throws JAXBException {
        return new ModelFileGenerator(new CamelNamespaceHandler().getJaxbContext());
    }
}

