/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionInterceptor
extends DelegateProcessor {
    public static final ExchangeProperty<Boolean> TRANSACTED = new ExchangeProperty("transacted", "org.apache.camel.transacted", Boolean.class);
    private static final transient Log LOG = LogFactory.getLog(TransactionInterceptor.class);
    private final TransactionTemplate transactionTemplate;
    private ThreadLocal<RedeliveryData> previousRollback = new ThreadLocal<RedeliveryData>(){

        @Override
        protected RedeliveryData initialValue() {
            return new RedeliveryData();
        }
    };
    private RedeliveryPolicy redeliveryPolicy;

    public TransactionInterceptor(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public TransactionInterceptor(Processor processor, TransactionTemplate transactionTemplate) {
        super(processor);
        this.transactionTemplate = transactionTemplate;
    }

    public TransactionInterceptor(Processor processor, TransactionTemplate transactionTemplate, RedeliveryPolicy redeliveryPolicy) {
        this(processor, transactionTemplate);
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public String toString() {
        return "TransactionInterceptor:" + this.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getProcessor() + "]";
    }

    public void process(final Exchange exchange) {
        LOG.debug((Object)"Transaction begin");
        final RedeliveryData redeliveryData = this.previousRollback.get();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (TransactionInterceptor.this.redeliveryPolicy != null && redeliveryData.previousRollback) {
                    redeliveryData.redeliveryDelay = TransactionInterceptor.this.redeliveryPolicy.sleep(redeliveryData.redeliveryDelay);
                }
                RuntimeCamelException rce = null;
                boolean activeTx = false;
                try {
                    activeTx = TransactionSynchronizationManager.isActualTransactionActive();
                    if (!activeTx) {
                        boolean bl = activeTx = status.isNewTransaction() && !status.isCompleted();
                        if (!activeTx && DefaultTransactionStatus.class.isAssignableFrom(status.getClass())) {
                            DefaultTransactionStatus defStatus = (DefaultTransactionStatus)DefaultTransactionStatus.class.cast(status);
                            boolean bl2 = activeTx = defStatus.hasTransaction() && !status.isCompleted();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Is actual transaction active: " + activeTx));
                    }
                    if (activeTx) {
                        TRANSACTED.set(exchange, (Object)Boolean.TRUE);
                    }
                    TransactionInterceptor.this.processNext(exchange);
                    if (exchange.getException() != null) {
                        rce = new RuntimeCamelException(exchange.getException());
                    }
                }
                catch (Exception e) {
                    rce = new RuntimeCamelException((Throwable)e);
                }
                if (rce != null) {
                    redeliveryData.previousRollback = true;
                    if (activeTx) {
                        status.setRollbackOnly();
                        LOG.debug((Object)"Transaction rollback");
                    }
                    throw rce;
                }
            }
        });
        redeliveryData.previousRollback = false;
        redeliveryData.redeliveryDelay = 0L;
        LOG.debug((Object)"Transaction commit");
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    protected String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKNOWN";
            }
        }
        return rc;
    }

    protected static class RedeliveryData {
        boolean previousRollback;
        long redeliveryDelay;

        protected RedeliveryData() {
        }
    }
}

