/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.Properties;
import org.apache.camel.Property;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.AnnotationExpressionFactory;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanInfo {
    private static final transient Log LOG = LogFactory.getLog(BeanInfo.class);
    private final CamelContext camelContext;
    private Class type;
    private ParameterMappingStrategy strategy;
    private Map<String, MethodInfo> operations = new ConcurrentHashMap<String, MethodInfo>();
    private MethodInfo defaultMethod;
    private List<MethodInfo> operationsWithBody = new ArrayList<MethodInfo>();

    public BeanInfo(CamelContext camelContext, Class type, ParameterMappingStrategy strategy) {
        this.camelContext = camelContext;
        this.type = type;
        this.strategy = strategy;
        this.introspect(this.getType());
        if (this.operations.size() == 1) {
            Collection<MethodInfo> methodInfos = this.operations.values();
            Iterator<MethodInfo> i$ = methodInfos.iterator();
            while (i$.hasNext()) {
                MethodInfo methodInfo;
                this.defaultMethod = methodInfo = i$.next();
            }
        }
    }

    public Class getType() {
        return this.type;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public MethodInvocation createInvocation(Method method, Object pojo, Exchange exchange) throws RuntimeCamelException {
        MethodInfo methodInfo = this.introspect(this.type, method);
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        return null;
    }

    public MethodInvocation createInvocation(Object pojo, Exchange exchange) throws RuntimeCamelException, AmbiguousMethodCallException {
        MethodInfo methodInfo = null;
        String name = (String)exchange.getIn().getHeader("org.apache.camel.MethodName", String.class);
        if (name != null) {
            methodInfo = this.operations.get(name);
        }
        if (methodInfo == null) {
            methodInfo = this.chooseMethod(pojo, exchange);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultMethod;
        }
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        return null;
    }

    protected void introspect(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!this.isValidMethod(clazz, method)) continue;
            this.introspect(clazz, method);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.introspect(superclass);
        }
    }

    protected MethodInfo introspect(Class clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        Expression[] parameterExpressions = new Expression[parameterTypes.length];
        ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        ArrayList<ParameterInfo> bodyParameters = new ArrayList<ParameterInfo>();
        boolean hasCustomAnnotation = false;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations);
            hasCustomAnnotation |= expression != null;
            if (expression == null) {
                hasCustomAnnotation |= ObjectHelper.hasAnnotation((Annotation[])parameterAnnotations, Body.class);
                if (bodyParameters.isEmpty()) {
                    expression = ExpressionBuilder.bodyExpression(parameterType);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No expression available for method: " + method.toString() + " which already has a body so ignoring parameter: " + i + " so ignoring method"));
                    }
                    return null;
                }
            }
            ParameterInfo parameterInfo = new ParameterInfo(i, parameterType, parameterAnnotations, expression);
            parameters.add(parameterInfo);
            if (!this.isPossibleBodyParameter(parameterAnnotations)) continue;
            bodyParameters.add(parameterInfo);
        }
        String opName = method.getName();
        MethodInfo methodInfo = new MethodInfo(clazz, method, parameters, bodyParameters, hasCustomAnnotation);
        this.operations.put(opName, methodInfo);
        if (methodInfo.hasBodyParameter()) {
            this.operationsWithBody.add(methodInfo);
        }
        return methodInfo;
    }

    protected MethodInfo chooseMethod(Object pojo, Exchange exchange) throws AmbiguousMethodCallException {
        if (this.operationsWithBody.size() == 1) {
            return this.operationsWithBody.get(0);
        }
        if (!this.operationsWithBody.isEmpty()) {
            Message in = exchange.getIn();
            Object body = in.getBody();
            if (body != null) {
                Class<?> bodyType = body.getClass();
                ArrayList<MethodInfo> possibles = new ArrayList<MethodInfo>();
                for (MethodInfo methodInfo : this.operationsWithBody) {
                    if (!methodInfo.bodyParameterMatches(bodyType)) continue;
                    possibles.add(methodInfo);
                }
                if (possibles.size() == 1) {
                    return (MethodInfo)possibles.get(0);
                }
                if (possibles.isEmpty()) {
                    Object newBody = null;
                    MethodInfo matched = null;
                    for (MethodInfo methodInfo : this.operationsWithBody) {
                        Object value = ExchangeHelper.convertToType((Exchange)exchange, (Class)methodInfo.getBodyParameterType(), (Object)body);
                        if (value == null) continue;
                        if (newBody != null) {
                            throw new AmbiguousMethodCallException(exchange, Arrays.asList(matched, methodInfo));
                        }
                        newBody = value;
                        matched = methodInfo;
                    }
                    if (matched != null) {
                        in.setBody(newBody);
                        return matched;
                    }
                } else {
                    MethodInfo chosen = null;
                    for (MethodInfo possible : possibles) {
                        if (!possible.isHasCustomAnnotation()) continue;
                        if (chosen != null) {
                            chosen = null;
                            break;
                        }
                        chosen = possible;
                    }
                    if (chosen != null) {
                        return chosen;
                    }
                    throw new AmbiguousMethodCallException(exchange, possibles);
                }
            }
            return null;
        }
        return null;
    }

    protected Expression createParameterUnmarshalExpression(Class clazz, Method method, Class parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    protected boolean isPossibleBodyParameter(Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Property) && !(annotation instanceof Header)) continue;
                return false;
            }
        }
        return true;
    }

    protected Expression createParameterUnmarshalExpressionForAnnotation(Class clazz, Method method, Class parameterType, Annotation annotation) {
        if (annotation instanceof Property) {
            Property propertyAnnotation = (Property)annotation;
            return ExpressionBuilder.propertyExpression((String)propertyAnnotation.name());
        }
        if (annotation instanceof Properties) {
            return ExpressionBuilder.propertiesExpresion();
        }
        if (annotation instanceof Header) {
            Header headerAnnotation = (Header)annotation;
            return ExpressionBuilder.headerExpression((String)headerAnnotation.name());
        }
        if (annotation instanceof Headers) {
            return ExpressionBuilder.headersExpresion();
        }
        LanguageAnnotation languageAnnotation = annotation.annotationType().getAnnotation(LanguageAnnotation.class);
        if (languageAnnotation != null) {
            Class type = languageAnnotation.factory();
            Object object = this.camelContext.getInjector().newInstance(type);
            if (object instanceof AnnotationExpressionFactory) {
                AnnotationExpressionFactory expressionFactory = (AnnotationExpressionFactory)object;
                return expressionFactory.createExpression(this.camelContext, annotation, languageAnnotation, parameterType);
            }
            LOG.error((Object)("Ignoring bad annotation: " + languageAnnotation + "on method: " + method + " which declares a factory: " + type.getName() + " which does not implement " + AnnotationExpressionFactory.class.getName()));
        }
        return null;
    }

    protected boolean isValidMethod(Class clazz, Method method) {
        return Modifier.isPublic(method.getModifiers());
    }
}

