/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.spi.Injector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringInjector
implements Injector {
    private static final transient Log LOG = LogFactory.getLog(SpringInjector.class);
    private final AbstractRefreshableApplicationContext applicationContext;
    private int autowireMode = 3;
    private boolean dependencyCheck;

    public SpringInjector(AbstractRefreshableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> T newInstance(Class<T> type) {
        Object value = this.applicationContext.getBeanFactory().createBean(type, this.autowireMode, this.dependencyCheck);
        return type.cast(value);
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }
}

