/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.xml;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.spring.xml.BuilderStatement;
import org.apache.camel.spring.xml.MethodInfo;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderAction {
    private final MethodInfo methodInfo;
    private final HashMap<String, Object> parameterValues;

    public BuilderAction(MethodInfo methodInfo, HashMap<String, Object> parameterValues) {
        this.methodInfo = methodInfo;
        this.parameterValues = parameterValues;
    }

    public Object invoke(BeanFactory beanFactory, Object rootBuilder, Object contextBuilder) {
        SimpleTypeConverter converter = new SimpleTypeConverter();
        Object[] args = new Object[this.methodInfo.parameters.size()];
        int pos = 0;
        for (Map.Entry<String, Class> entry : this.methodInfo.parameters.entrySet()) {
            String paramName = entry.getKey();
            Class paramClass = entry.getValue();
            Object value = this.parameterValues.get(paramName);
            if (value == null) continue;
            value = this.replaceBeanReferences(beanFactory, rootBuilder, value);
            args[pos] = converter.convertIfNecessary(value, paramClass);
        }
        try {
            return this.methodInfo.method.invoke(contextBuilder, args);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Object replaceBeanReferences(BeanFactory beanFactory, Object rootBuilder, Object value) {
        if (value.getClass() == RuntimeBeanReference.class) {
            String beanName = ((RuntimeBeanReference)value).getBeanName();
            value = beanFactory.getBean(beanName);
        }
        if (value.getClass() == BuilderStatement.class) {
            BuilderStatement bs = (BuilderStatement)value;
            value = bs.create(beanFactory, rootBuilder);
        }
        if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.set(i, this.replaceBeanReferences(beanFactory, rootBuilder, list.get(i)));
            }
        }
        return value;
    }

    public String getName() {
        return this.methodInfo.getName();
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }
}

