/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.RouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CamelContextFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private CamelContext context;
    private RouteBuilder routeBuilder;
    private List<RouteBuilder> additionalBuilders = new ArrayList<RouteBuilder>();
    private String[] packages = new String[0];
    private ApplicationContext applicationContext;

    public Object getObject() throws Exception {
        return this.getContext();
    }

    public Class getObjectType() {
        return SpringCamelContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.getContext();
        this.findRouteBuiders();
        this.installRoutes();
        this.getContext().start();
    }

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public CamelContext getContext() throws Exception {
        if (this.context == null) {
            this.context = new SpringCamelContext(this.getApplicationContext());
        }
        return this.context;
    }

    public void setContext(CamelContext context) {
        this.context = context;
    }

    public RouteBuilder getRouteBuilder() {
        return this.routeBuilder;
    }

    public void setRouteBuilder(RouteBuilder routeBuilder) {
        this.routeBuilder = routeBuilder;
    }

    public void setRouteBuilders(RouteBuilder[] builders) {
        for (RouteBuilder builder : builders) {
            this.additionalBuilders.add(builder);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    protected void installRoutes() throws Exception {
        for (RouteBuilder routeBuilder : this.additionalBuilders) {
            this.getContext().addRoutes(routeBuilder);
        }
        if (this.routeBuilder != null) {
            this.getContext().addRoutes(this.routeBuilder);
        }
    }

    protected void findRouteBuiders() throws IllegalAccessException, InstantiationException {
        if (this.packages != null && this.packages.length > 0) {
            RouteBuilderFinder finder = new RouteBuilderFinder(this);
            finder.appendBuilders(this.additionalBuilders);
        }
    }
}

