/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelRouteControllerDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.GlobalOptionsDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RestContextRefDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteConfigurationContextRefDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateContextRefDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformersDefinition;
import org.apache.camel.model.validator.ValidatorsDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.spi.BridgePropertyPlaceholderConfigurer;
import org.apache.camel.spring.xml.CamelBeanPostProcessor;
import org.apache.camel.spring.xml.CamelConsumerTemplateFactoryBean;
import org.apache.camel.spring.xml.CamelEndpointFactoryBean;
import org.apache.camel.spring.xml.CamelFluentProducerTemplateFactoryBean;
import org.apache.camel.spring.xml.CamelProducerTemplateFactoryBean;
import org.apache.camel.spring.xml.CamelRedeliveryPolicyFactoryBean;
import org.apache.camel.spring.xml.CamelThreadPoolFactoryBean;
import org.apache.camel.spring.xml.ContextScanRouteBuilderFinder;
import org.apache.camel.spring.xml.PackageScanRouteBuilderFinder;
import org.apache.camel.spring.xml.SpringErrorHandlerDefinition;
import org.apache.camel.spring.xml.XmlCamelContextConfigurer;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.springframework.context.Phased;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

@Metadata(label="spring,configuration")
@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends AbstractCamelContextFactoryBean<SpringCamelContext>
implements FactoryBean<SpringCamelContext>,
InitializingBean,
DisposableBean,
ApplicationContextAware,
Lifecycle,
Phased,
ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextFactoryBean.class);
    @XmlAttribute(name="depends-on")
    @Metadata(displayName="Depends On")
    private String dependsOn;
    @XmlAttribute
    @Metadata(defaultValue="Default")
    private StartupSummaryLevel startupSummaryLevel;
    @XmlAttribute
    private String trace;
    @XmlAttribute
    private String backlogTrace;
    @XmlAttribute
    private String tracePattern;
    @XmlAttribute
    private String traceLoggingFormat;
    @XmlAttribute
    private String debug;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String messageHistory;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String sourceLocationEnabled;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String logMask;
    @XmlAttribute
    private String logExhaustedMessageBody;
    @XmlAttribute
    private String streamCache;
    @XmlAttribute
    private String delayer;
    @XmlAttribute
    private String errorHandlerRef;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String autoStartup;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String shutdownEager;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String dumpRoutes;
    @XmlAttribute
    @Metadata(displayName="Use MDC Logging")
    private String useMDCLogging;
    @XmlAttribute
    @Metadata(displayName="MDC Logging Keys Pattern")
    private String mdcLoggingKeysPattern;
    @XmlAttribute
    private String useDataType;
    @XmlAttribute
    private String useBreadcrumb;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String beanPostProcessorEnabled;
    @XmlAttribute
    private String allowUseOriginalMessage;
    @XmlAttribute
    private String caseInsensitiveHeaders;
    @XmlAttribute
    private String autowiredEnabled;
    @XmlAttribute
    private String runtimeEndpointRegistryEnabled;
    @XmlAttribute
    @Metadata(defaultValue="#name#")
    private String managementNamePattern;
    @XmlAttribute
    @Metadata(defaultValue="Camel (#camelId#) thread ##counter# - #name#")
    private String threadNamePattern;
    @XmlAttribute
    @Metadata(defaultValue="Default")
    private ShutdownRoute shutdownRoute;
    @XmlAttribute
    @Metadata(defaultValue="CompleteCurrentTaskOnly")
    private ShutdownRunningTask shutdownRunningTask;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String loadTypeConverters;
    @XmlAttribute
    private String typeConverterStatisticsEnabled;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String loadHealthChecks;
    @XmlAttribute
    private String inflightRepositoryBrowseEnabled;
    @XmlAttribute
    @Metadata(defaultValue="Ignore")
    private TypeConverterExists typeConverterExists;
    @XmlAttribute
    @Metadata(defaultValue="DEBUG")
    private LoggingLevel typeConverterExistsLoggingLevel;
    @XmlElement(name="globalOptions")
    private GlobalOptionsDefinition globalOptions;
    @XmlElement(name="propertyPlaceholder", type=CamelPropertyPlaceholderDefinition.class)
    private CamelPropertyPlaceholderDefinition camelPropertyPlaceholder;
    @XmlElement(name="package")
    private String[] packages = new String[0];
    @XmlElement(name="packageScan", type=PackageScanDefinition.class)
    private PackageScanDefinition packageScan;
    @XmlElement(name="contextScan", type=ContextScanDefinition.class)
    private ContextScanDefinition contextScan;
    @XmlElement(name="streamCaching", type=CamelStreamCachingStrategyDefinition.class)
    private CamelStreamCachingStrategyDefinition camelStreamCachingStrategy;
    @XmlElement(name="jmxAgent", type=CamelJMXAgentDefinition.class)
    @Metadata(displayName="JMX Agent")
    private CamelJMXAgentDefinition camelJMXAgent;
    @XmlElement(name="routeController", type=CamelRouteControllerDefinition.class)
    private CamelRouteControllerDefinition camelRouteController;
    @XmlElements(value={@XmlElement(name="template", type=CamelProducerTemplateFactoryBean.class), @XmlElement(name="fluentTemplate", type=CamelFluentProducerTemplateFactoryBean.class), @XmlElement(name="consumerTemplate", type=CamelConsumerTemplateFactoryBean.class)})
    private List<AbstractCamelFactoryBean<?>> beansFactory;
    @XmlElements(value={@XmlElement(name="errorHandler", type=SpringErrorHandlerDefinition.class)})
    private List<?> beans;
    @XmlElement(name="defaultServiceCallConfiguration")
    private ServiceCallConfigurationDefinition defaultServiceCallConfiguration;
    @XmlElement(name="serviceCallConfiguration", type=ServiceCallConfigurationDefinition.class)
    private List<ServiceCallConfigurationDefinition> serviceCallConfigurations;
    @XmlElement(name="defaultResilience4jConfiguration")
    private Resilience4jConfigurationDefinition defaultResilience4jConfiguration;
    @XmlElement(name="resilience4jConfiguration", type=Resilience4jConfigurationDefinition.class)
    private List<Resilience4jConfigurationDefinition> resilience4jConfigurations;
    @XmlElement(name="defaultFaultToleranceConfiguration")
    private FaultToleranceConfigurationDefinition defaultFaultToleranceConfiguration;
    @XmlElement(name="faultToleranceConfiguration", type=Resilience4jConfigurationDefinition.class)
    private List<FaultToleranceConfigurationDefinition> faultToleranceConfigurations;
    @XmlElement(name="routeConfigurationContextRef")
    private List<RouteConfigurationContextRefDefinition> routeConfigurationRefs = new ArrayList<RouteConfigurationContextRefDefinition>();
    @XmlElement(name="routeTemplateContextRef")
    private List<RouteTemplateContextRefDefinition> routeTemplateRefs = new ArrayList<RouteTemplateContextRefDefinition>();
    @XmlElement(name="routeBuilder")
    private List<RouteBuilderDefinition> builderRefs = new ArrayList<RouteBuilderDefinition>();
    @XmlElement(name="routeContextRef")
    private List<RouteContextRefDefinition> routeRefs = new ArrayList<RouteContextRefDefinition>();
    @XmlElement(name="restContextRef")
    private List<RestContextRefDefinition> restRefs = new ArrayList<RestContextRefDefinition>();
    @XmlElement(name="threadPoolProfile")
    private List<ThreadPoolProfileDefinition> threadPoolProfiles;
    @XmlElement(name="threadPool")
    private List<CamelThreadPoolFactoryBean> threadPools;
    @XmlElement(name="endpoint")
    private List<CamelEndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats")
    private DataFormatsDefinition dataFormats;
    @XmlElement(name="transformers")
    private TransformersDefinition transformers;
    @XmlElement(name="validators")
    private ValidatorsDefinition validators;
    @XmlElement(name="redeliveryPolicyProfile")
    private List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies;
    @XmlElement(name="onException")
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion")
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlElement(name="intercept")
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom")
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint")
    private List<InterceptSendToEndpointDefinition> interceptSendToEndpoints = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="restConfiguration")
    private RestConfigurationDefinition restConfiguration;
    @XmlElement(name="rest")
    private List<RestDefinition> rests = new ArrayList<RestDefinition>();
    @XmlElement(name="routeConfiguration")
    private List<RouteConfigurationDefinition> routeConfigurations = new ArrayList<RouteConfigurationDefinition>();
    @XmlElement(name="routeTemplate")
    private List<RouteTemplateDefinition> routeTemplates = new ArrayList<RouteTemplateDefinition>();
    @XmlElement(name="templatedRoute")
    private List<TemplatedRouteDefinition> templatedRoutes = new ArrayList<TemplatedRouteDefinition>();
    @XmlElement(name="route")
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private BeanPostProcessor beanPostProcessor;
    @XmlTransient
    private boolean implicitId;

    public Class<SpringCamelContext> getObjectType() {
        return SpringCamelContext.class;
    }

    protected <S> S getBeanForType(Class<S> clazz) {
        ApplicationContext parentContext;
        Object bean = null;
        String[] names = this.getApplicationContext().getBeanNamesForType(clazz, true, true);
        if (names.length == 1) {
            bean = this.getApplicationContext().getBean(names[0], clazz);
        }
        if (bean == null && (parentContext = this.getApplicationContext().getParent()) != null && (names = parentContext.getBeanNamesForType(clazz, true, true)).length == 1) {
            bean = parentContext.getBean(names[0], clazz);
        }
        return (S)bean;
    }

    protected void findRouteBuildersByPackageScan(String[] packages, PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
        ((SpringCamelContext)this.getContext()).getPackageScanClassResolver().addFilter(filter);
        PackageScanRouteBuilderFinder finder = new PackageScanRouteBuilderFinder((SpringCamelContext)this.getContext(), packages, this.getContextClassLoaderOnStart(), this.getBeanPostProcessor(), ((SpringCamelContext)this.getContext()).getPackageScanClassResolver());
        finder.appendBuilders(builders);
        ((SpringCamelContext)this.getContext()).getPackageScanClassResolver().removeFilter(filter);
    }

    protected void findRouteBuildersByContextScan(PackageScanFilter filter, boolean includeNonSingletons, List<RoutesBuilder> builders) throws Exception {
        ContextScanRouteBuilderFinder finder = new ContextScanRouteBuilderFinder((SpringCamelContext)this.getContext(), filter, includeNonSingletons);
        finder.appendBuilders(builders);
    }

    protected void initBeanPostProcessor(SpringCamelContext context) {
        if (this.beanPostProcessor != null) {
            if (this.beanPostProcessor instanceof ApplicationContextAware) {
                ((ApplicationContextAware)this.beanPostProcessor).setApplicationContext(this.applicationContext);
            }
            if (this.beanPostProcessor instanceof CamelBeanPostProcessor) {
                ((CamelBeanPostProcessor)this.beanPostProcessor).setCamelContext((CamelContext)this.getContext());
            }
            if (this.beanPostProcessor instanceof org.apache.camel.spi.CamelBeanPostProcessor) {
                context.setBeanPostProcessor((org.apache.camel.spi.CamelBeanPostProcessor)this.beanPostProcessor);
            }
        }
    }

    protected void postProcessBeforeInit(RouteBuilder builder) {
        if (this.beanPostProcessor != null) {
            this.beanPostProcessor.postProcessBeforeInitialization((Object)builder, builder.toString());
        }
    }

    public void afterPropertiesSet() throws Exception {
        StopWatch watch = new StopWatch();
        super.afterPropertiesSet();
        Boolean shutdownEager = CamelContextHelper.parseBoolean((CamelContext)this.getContext(), (String)this.getShutdownEager());
        if (shutdownEager != null) {
            LOG.debug("Using shutdownEager: {}", (Object)shutdownEager);
            ((SpringCamelContext)this.getContext()).setShutdownEager(shutdownEager.booleanValue());
        }
        LOG.debug("afterPropertiesSet() took {} millis", (Object)watch.taken());
    }

    protected void initCustomRegistry(SpringCamelContext context) {
        Registry registry = this.getBeanForType(Registry.class);
        if (registry != null) {
            LOG.info("Using custom Registry: {}", (Object)registry);
            context.setRegistry(registry);
        }
    }

    protected void initPropertyPlaceholder() throws Exception {
        super.initPropertyPlaceholder();
        Map beans = this.applicationContext.getBeansOfType(BridgePropertyPlaceholderConfigurer.class);
        if (beans.size() == 1) {
            BridgePropertyPlaceholderConfigurer configurer = (BridgePropertyPlaceholderConfigurer)beans.values().iterator().next();
            String id = (String)beans.keySet().iterator().next();
            LOG.info("Bridging Camel and Spring property placeholder configurer with id: {}", (Object)id);
            PropertiesComponent pc = (PropertiesComponent)((SpringCamelContext)this.getContext()).getPropertiesComponent();
            pc.setSystemPropertiesMode(configurer.getSystemPropertiesMode());
            configurer.setParser(pc.getPropertiesParser());
            pc.setPropertiesParser((PropertiesParser)configurer);
            pc.addPropertiesSource((PropertiesSource)configurer);
        } else if (beans.size() > 1) {
            LOG.warn("Cannot bridge Camel and Spring property placeholders, as exact only 1 bean of type BridgePropertyPlaceholderConfigurer must be defined, was {} beans defined.", (Object)beans.size());
        }
    }

    public void start() {
        try {
            this.setupRoutes();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        this.context.start();
    }

    public void stop() {
        if (this.context != null) {
            this.context.stop();
        }
    }

    public boolean isRunning() {
        return this.context != null && this.context.isRunning();
    }

    public int getPhase() {
        return 0x7FFFFFFE;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext appCtx;
        if (event.getSource() instanceof ApplicationContext && (appCtx = (ApplicationContext)event.getSource()).getId().endsWith(":management")) {
            return;
        }
        this.start();
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("No applicationContext has been injected!");
        }
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanPostProcessor(BeanPostProcessor postProcessor) {
        this.beanPostProcessor = postProcessor;
    }

    public BeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = this.newCamelContext();
        ctx.setApplicationContext(this.getApplicationContext());
        ctx.setName(this.getId());
        return ctx;
    }

    protected void configure(SpringCamelContext ctx) {
        try {
            XmlCamelContextConfigurer configurer;
            if (this.applicationContext.containsBean("xmlCamelContextConfigurer") && (configurer = (XmlCamelContextConfigurer)this.applicationContext.getBean("xmlCamelContextConfigurer", XmlCamelContextConfigurer.class)) != null) {
                configurer.configure(this.applicationContext, ctx);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected SpringCamelContext newCamelContext() {
        return new SpringCamelContext();
    }

    public SpringCamelContext getContext(boolean create) {
        if (this.context == null && create) {
            this.context = this.createContext();
            this.configure(this.context);
            this.context.build();
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    public List<RouteConfigurationDefinition> getRouteConfigurations() {
        return this.routeConfigurations;
    }

    public void setRouteConfigurations(List<RouteConfigurationDefinition> routeConfigurations) {
        this.routeConfigurations = routeConfigurations;
    }

    public List<RouteTemplateDefinition> getRouteTemplates() {
        return this.routeTemplates;
    }

    public void setRouteTemplates(List<RouteTemplateDefinition> routeTemplates) {
        this.routeTemplates = routeTemplates;
    }

    public List<TemplatedRouteDefinition> getTemplatedRoutes() {
        return this.templatedRoutes;
    }

    public void setTemplatedRoutes(List<TemplatedRouteDefinition> templatedRoutes) {
        this.templatedRoutes = templatedRoutes;
    }

    public List<RestDefinition> getRests() {
        return this.rests;
    }

    public void setRests(List<RestDefinition> rests) {
        this.rests = rests;
    }

    public RestConfigurationDefinition getRestConfiguration() {
        return this.restConfiguration;
    }

    public void setRestConfiguration(RestConfigurationDefinition restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    public List<CamelEndpointFactoryBean> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<CamelEndpointFactoryBean> endpoints) {
        this.endpoints = endpoints;
    }

    public List<CamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies() {
        return this.redeliveryPolicies;
    }

    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this.interceptSendToEndpoints;
    }

    public void setInterceptSendToEndpoints(List<InterceptSendToEndpointDefinition> interceptSendToEndpoints) {
        this.interceptSendToEndpoints = interceptSendToEndpoints;
    }

    public GlobalOptionsDefinition getGlobalOptions() {
        return this.globalOptions;
    }

    public void setGlobalOptions(GlobalOptionsDefinition globalOptions) {
        this.globalOptions = globalOptions;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public PackageScanDefinition getPackageScan() {
        return this.packageScan;
    }

    public void setPackageScan(PackageScanDefinition packageScan) {
        this.packageScan = packageScan;
    }

    public ContextScanDefinition getContextScan() {
        return this.contextScan;
    }

    public void setContextScan(ContextScanDefinition contextScan) {
        this.contextScan = contextScan;
    }

    public CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder() {
        return this.camelPropertyPlaceholder;
    }

    public void setCamelPropertyPlaceholder(CamelPropertyPlaceholderDefinition camelPropertyPlaceholder) {
        this.camelPropertyPlaceholder = camelPropertyPlaceholder;
    }

    public CamelStreamCachingStrategyDefinition getCamelStreamCachingStrategy() {
        return this.camelStreamCachingStrategy;
    }

    public void setCamelStreamCachingStrategy(CamelStreamCachingStrategyDefinition camelStreamCachingStrategy) {
        this.camelStreamCachingStrategy = camelStreamCachingStrategy;
    }

    public CamelRouteControllerDefinition getCamelRouteController() {
        return this.camelRouteController;
    }

    public void setCamelRouteController(CamelRouteControllerDefinition camelRouteController) {
        this.camelRouteController = camelRouteController;
    }

    public void setCamelJMXAgent(CamelJMXAgentDefinition agent) {
        this.camelJMXAgent = agent;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public StartupSummaryLevel getStartupSummaryLevel() {
        return this.startupSummaryLevel;
    }

    public void setStartupSummaryLevel(StartupSummaryLevel startupSummaryLevel) {
        this.startupSummaryLevel = startupSummaryLevel;
    }

    public String getBacklogTrace() {
        return this.backlogTrace;
    }

    public void setBacklogTrace(String backlogTrace) {
        this.backlogTrace = backlogTrace;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public String getTracePattern() {
        return this.tracePattern;
    }

    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
    }

    public String getTraceLoggingFormat() {
        return this.traceLoggingFormat;
    }

    public void setTraceLoggingFormat(String traceLoggingFormat) {
        this.traceLoggingFormat = traceLoggingFormat;
    }

    public String getMessageHistory() {
        return this.messageHistory;
    }

    public void setMessageHistory(String messageHistory) {
        this.messageHistory = messageHistory;
    }

    public String getSourceLocationEnabled() {
        return this.sourceLocationEnabled;
    }

    public void setSourceLocationEnabled(String sourceLocationEnabled) {
        this.sourceLocationEnabled = sourceLocationEnabled;
    }

    public String getLogMask() {
        return this.logMask;
    }

    public void setLogMask(String logMask) {
        this.logMask = logMask;
    }

    public String getLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(String logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public String getStreamCache() {
        return this.streamCache;
    }

    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    public String getDelayer() {
        return this.delayer;
    }

    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    public String getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    public String getShutdownEager() {
        return this.shutdownEager;
    }

    public void setShutdownEager(String shutdownEager) {
        this.shutdownEager = shutdownEager;
    }

    public String getDumpRoutes() {
        return this.dumpRoutes;
    }

    public void setDumpRoutes(String dumpRoutes) {
        this.dumpRoutes = dumpRoutes;
    }

    public String getUseMDCLogging() {
        return this.useMDCLogging;
    }

    public void setUseMDCLogging(String useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    public String getMDCLoggingKeysPattern() {
        return this.mdcLoggingKeysPattern;
    }

    public void setMDCLoggingKeysPattern(String mdcLoggingKeysPattern) {
        this.mdcLoggingKeysPattern = mdcLoggingKeysPattern;
    }

    public String getUseDataType() {
        return this.useDataType;
    }

    public void setUseDataType(String useDataType) {
        this.useDataType = useDataType;
    }

    public String getUseBreadcrumb() {
        return this.useBreadcrumb;
    }

    public void setUseBreadcrumb(String useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    public String getBeanPostProcessorEnabled() {
        return this.beanPostProcessorEnabled;
    }

    public void setBeanPostProcessorEnabled(String beanPostProcessorEnabled) {
        this.beanPostProcessorEnabled = beanPostProcessorEnabled;
    }

    public String getAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage;
    }

    public void setAllowUseOriginalMessage(String allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    public String getCaseInsensitiveHeaders() {
        return this.caseInsensitiveHeaders;
    }

    public void setCaseInsensitiveHeaders(String caseInsensitiveHeaders) {
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
    }

    public String getAutowiredEnabled() {
        return this.autowiredEnabled;
    }

    public void setAutowiredEnabled(String autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getRuntimeEndpointRegistryEnabled() {
        return this.runtimeEndpointRegistryEnabled;
    }

    public void setRuntimeEndpointRegistryEnabled(String runtimeEndpointRegistryEnabled) {
        this.runtimeEndpointRegistryEnabled = runtimeEndpointRegistryEnabled;
    }

    public String getInflightRepositoryBrowseEnabled() {
        return this.inflightRepositoryBrowseEnabled;
    }

    public void setInflightRepositoryBrowseEnabled(String inflightRepositoryBrowseEnabled) {
        this.inflightRepositoryBrowseEnabled = inflightRepositoryBrowseEnabled;
    }

    public String getManagementNamePattern() {
        return this.managementNamePattern;
    }

    public void setManagementNamePattern(String managementNamePattern) {
        this.managementNamePattern = managementNamePattern;
    }

    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    public String getLoadTypeConverters() {
        return this.loadTypeConverters;
    }

    public void setLoadTypeConverters(String loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
    }

    public String getLoadHealthChecks() {
        return this.loadHealthChecks;
    }

    public void setLoadHealthChecks(String loadHealthChecks) {
        this.loadHealthChecks = loadHealthChecks;
    }

    public String getTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled;
    }

    public void setTypeConverterStatisticsEnabled(String typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    public List<RouteConfigurationContextRefDefinition> getRouteConfigurationRefs() {
        return this.routeConfigurationRefs;
    }

    public void setRouteConfigurationRefs(List<RouteConfigurationContextRefDefinition> routeConfigurationRefs) {
        this.routeConfigurationRefs = routeConfigurationRefs;
    }

    public List<RouteTemplateContextRefDefinition> getRouteTemplateRefs() {
        return this.routeTemplateRefs;
    }

    public void setRouteTemplateRefs(List<RouteTemplateContextRefDefinition> routeTemplateRefs) {
        this.routeTemplateRefs = routeTemplateRefs;
    }

    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderDefinition> builderRefs) {
        this.builderRefs = builderRefs;
    }

    public List<RouteContextRefDefinition> getRouteRefs() {
        return this.routeRefs;
    }

    public void setRouteRefs(List<RouteContextRefDefinition> routeRefs) {
        this.routeRefs = routeRefs;
    }

    public List<RestContextRefDefinition> getRestRefs() {
        return this.restRefs;
    }

    public void setRestRefs(List<RestContextRefDefinition> restRefs) {
        this.restRefs = restRefs;
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    public void setDataFormats(DataFormatsDefinition dataFormats) {
        this.dataFormats = dataFormats;
    }

    public DataFormatsDefinition getDataFormats() {
        return this.dataFormats;
    }

    public void setTransformers(TransformersDefinition transformers) {
        this.transformers = transformers;
    }

    public TransformersDefinition getTransformers() {
        return this.transformers;
    }

    public void setValidators(ValidatorsDefinition validators) {
        this.validators = validators;
    }

    public ValidatorsDefinition getValidators() {
        return this.validators;
    }

    public void setRedeliveryPolicies(List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies) {
        this.redeliveryPolicies = redeliveryPolicies;
    }

    public List<AbstractCamelFactoryBean<?>> getBeansFactory() {
        return this.beansFactory;
    }

    public void setBeansFactory(List<AbstractCamelFactoryBean<?>> beansFactory) {
        this.beansFactory = beansFactory;
    }

    public List<?> getBeans() {
        return this.beans;
    }

    public void setBeans(List<?> beans) {
        this.beans = beans;
    }

    public ServiceCallConfigurationDefinition getDefaultServiceCallConfiguration() {
        return this.defaultServiceCallConfiguration;
    }

    public void setDefaultServiceCallConfiguration(ServiceCallConfigurationDefinition defaultServiceCallConfiguration) {
        this.defaultServiceCallConfiguration = defaultServiceCallConfiguration;
    }

    public List<ServiceCallConfigurationDefinition> getServiceCallConfigurations() {
        return this.serviceCallConfigurations;
    }

    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> serviceCallConfigurations) {
        this.serviceCallConfigurations = serviceCallConfigurations;
    }

    public Resilience4jConfigurationDefinition getDefaultResilience4jConfiguration() {
        return this.defaultResilience4jConfiguration;
    }

    public void setDefaultResilience4jConfiguration(Resilience4jConfigurationDefinition defaultResilience4jConfiguration) {
        this.defaultResilience4jConfiguration = defaultResilience4jConfiguration;
    }

    public List<Resilience4jConfigurationDefinition> getResilience4jConfigurations() {
        return this.resilience4jConfigurations;
    }

    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> resilience4jConfigurations) {
        this.resilience4jConfigurations = resilience4jConfigurations;
    }

    public FaultToleranceConfigurationDefinition getDefaultFaultToleranceConfiguration() {
        return this.defaultFaultToleranceConfiguration;
    }

    public void setDefaultFaultToleranceConfiguration(FaultToleranceConfigurationDefinition defaultFaultToleranceConfiguration) {
        this.defaultFaultToleranceConfiguration = defaultFaultToleranceConfiguration;
    }

    public List<FaultToleranceConfigurationDefinition> getFaultToleranceConfigurations() {
        return this.faultToleranceConfigurations;
    }

    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> faultToleranceConfigurations) {
        this.faultToleranceConfigurations = faultToleranceConfigurations;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public List<ThreadPoolProfileDefinition> getThreadPoolProfiles() {
        return this.threadPoolProfiles;
    }

    public void setThreadPoolProfiles(List<ThreadPoolProfileDefinition> threadPoolProfiles) {
        this.threadPoolProfiles = threadPoolProfiles;
    }

    public List<CamelThreadPoolFactoryBean> getThreadPools() {
        return this.threadPools;
    }

    public void setThreadPools(List<CamelThreadPoolFactoryBean> threadPools) {
        this.threadPools = threadPools;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public boolean isImplicitId() {
        return this.implicitId;
    }

    public void setImplicitId(boolean flag) {
        this.implicitId = flag;
    }
}

