/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.security;

import javax.security.auth.Subject;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.spring.security.AuthenticationAdapter;
import org.apache.camel.component.spring.security.DefaultAuthenticationAdapter;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spi.AuthorizationPolicy;
import org.apache.camel.support.processor.DelegateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.event.AuthorizationDeniedEvent;
import org.springframework.security.authorization.event.AuthorizationGrantedEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class SpringSecurityAuthorizationPolicy
extends IdentifiedType
implements AuthorizationPolicy,
InitializingBean,
ApplicationEventPublisherAware {
    private static final Logger LOG = LoggerFactory.getLogger(SpringSecurityAuthorizationPolicy.class);
    private AuthorizationManager<Exchange> authorizationManager;
    private AuthenticationManager authenticationManager;
    private AuthenticationAdapter authenticationAdapter;
    private ApplicationEventPublisher eventPublisher;
    private boolean alwaysReauthenticate;
    private boolean useThreadSecurityContext = true;

    public void beforeWrap(Route route, NamedNode definition) {
    }

    public Processor wrap(Route route, Processor processor) {
        return new AuthorizeDelegateProcess(processor);
    }

    protected void beforeProcess(Exchange exchange) throws Exception {
        try {
            Authentication authToken = this.getAuthentication(exchange.getIn());
            if (authToken == null) {
                throw new CamelAuthorizationException("Cannot find the Authentication instance.", exchange);
            }
            Authentication authentication = this.authenticateIfRequired(authToken);
            AuthorizationDecision decision = this.authorizationManager.check(() -> authentication, (Object)exchange);
            try {
                this.authorizationManager.verify(() -> authentication, (Object)exchange);
            }
            catch (AccessDeniedException accessDeniedException) {
                exchange.getIn().setHeader("CamelAuthenticationFailurePolicyId", (Object)this.getId());
                AuthorizationDeniedEvent event = new AuthorizationDeniedEvent(() -> authentication, (Object)exchange, decision);
                this.publishEvent((ApplicationEvent)event);
                throw accessDeniedException;
            }
            this.publishEvent((ApplicationEvent)new AuthorizationGrantedEvent(() -> authentication, (Object)exchange, decision));
        }
        catch (RuntimeException exception) {
            exchange.getIn().setHeader("CamelAuthenticationFailurePolicyId", (Object)this.getId());
            throw new CamelAuthorizationException("Cannot access the processor which has been protected.", exchange, (Throwable)exception);
        }
    }

    protected Authentication getAuthentication(Message message) {
        Subject subject = (Subject)message.getHeader("CamelAuthentication", Subject.class);
        Authentication answer = null;
        if (subject != null) {
            answer = this.getAuthenticationAdapter().toAuthentication(subject);
        }
        if (answer == null && this.useThreadSecurityContext) {
            answer = SecurityContextHolder.getContext().getAuthentication();
            LOG.debug("Get the authentication from SecurityContextHolder");
        }
        return answer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Assert.notNull(this.authorizationManager, (String)"An AuthorizationManager is required");
    }

    private Authentication authenticateIfRequired(Authentication authentication) {
        if (authentication.isAuthenticated() && !this.alwaysReauthenticate) {
            LOG.debug("Previously Authenticated: {}", (Object)authentication);
            return authentication;
        }
        authentication = this.authenticationManager.authenticate(authentication);
        LOG.debug("Successfully Authenticated: {}", (Object)authentication);
        return authentication;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationAdapter getAuthenticationAdapter() {
        if (this.authenticationAdapter == null) {
            SpringSecurityAuthorizationPolicy springSecurityAuthorizationPolicy = this;
            synchronized (springSecurityAuthorizationPolicy) {
                if (this.authenticationAdapter != null) {
                    return this.authenticationAdapter;
                }
                this.authenticationAdapter = new DefaultAuthenticationAdapter();
            }
        }
        return this.authenticationAdapter;
    }

    public void setAuthenticationAdapter(AuthenticationAdapter adapter) {
        this.authenticationAdapter = adapter;
    }

    public AuthorizationManager<Exchange> getAuthorizationManager() {
        return this.authorizationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public boolean isAlwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public void setAlwaysReauthenticate(boolean alwaysReauthenticate) {
        this.alwaysReauthenticate = alwaysReauthenticate;
    }

    public boolean isUseThreadSecurityContext() {
        return this.useThreadSecurityContext;
    }

    public void setUseThreadSecurityContext(boolean useThreadSecurityContext) {
        this.useThreadSecurityContext = useThreadSecurityContext;
    }

    public void setAuthenticationManager(AuthenticationManager newManager) {
        this.authenticationManager = newManager;
    }

    public void setAuthorizationManager(AuthorizationManager<Exchange> authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    private class AuthorizeDelegateProcess
    extends DelegateProcessor {
        AuthorizeDelegateProcess(Processor processor) {
            super(processor);
        }

        public void process(Exchange exchange) throws Exception {
            SpringSecurityAuthorizationPolicy.this.beforeProcess(exchange);
            this.processNext(exchange);
        }
    }
}

