/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.cloud.config;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.spring.cloud.config.SpringConfigProvider;
import org.apache.camel.component.spring.cloud.config.SpringConfigRemaindersCache;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.annotations.PeriodicTask;
import org.apache.camel.support.service.ServiceSupport;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.core.env.PropertySource;

@PeriodicTask(value="spring-config-refresh")
public class SpringCloudConfigReloadTriggerTask
extends ServiceSupport
implements CamelContextAware,
Runnable {
    private CamelContext camelContext;

    @Override
    public void run() {
        if (SpringConfigRemaindersCache.get().isEmpty()) {
            return;
        }
        ConfigData configData = new SpringConfigProvider().getConfigData(this.getCamelContext());
        for (Map.Entry<String, String> entry : SpringConfigRemaindersCache.get().entrySet()) {
            for (PropertySource propertySource : configData.getPropertySources()) {
                ContextReloadStrategy reload;
                if (!propertySource.containsProperty(entry.getKey()) || propertySource.getProperty(entry.getKey()).equals(entry.getValue()) || (reload = (ContextReloadStrategy)this.camelContext.hasService(ContextReloadStrategy.class)) == null) continue;
                reload.onReload((Object)this);
            }
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

