/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

public final class CamelPropertiesHelper {
    private CamelPropertiesHelper() {
    }

    public static boolean setCamelProperties(CamelContext context, Object target, Map<String, Object> properties, boolean failIfNotSet) throws Exception {
        ObjectHelper.notNull((Object)context, (String)"context");
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            boolean hit;
            String stringValue;
            String name;
            block5: {
                Map.Entry<String, Object> entry = it.next();
                name = entry.getKey();
                Object value = entry.getValue();
                stringValue = value != null ? value.toString() : null;
                hit = false;
                try {
                    hit = PropertyBindingSupport.bindProperty((CamelContext)context, (Object)target, (String)name, (Object)value);
                }
                catch (PropertyBindingException e) {
                    if (stringValue == null) break block5;
                    if (stringValue.startsWith("#")) {
                        stringValue = stringValue.substring(1);
                    }
                    stringValue = "#bean:" + stringValue;
                    hit = PropertyBindingSupport.bindProperty((CamelContext)context, (Object)target, (String)name, (Object)stringValue);
                }
            }
            if (hit) {
                it.remove();
                rc = true;
                continue;
            }
            if (!failIfNotSet) continue;
            throw new IllegalArgumentException("Cannot configure option [" + name + "] with value [" + stringValue + "] as the bean class [" + ObjectHelper.classCanonicalName((Object)target) + "] has no suitable setter method, or not possible to lookup a bean with the id [" + stringValue + "] in Spring Boot registry");
        }
        return rc;
    }
}

