/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.spring.boot.actuate.endpoint.AbstractCamelEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.camelhealthcheck")
public class CamelHealthCheckEndpoint
extends AbstractCamelEndpoint<Collection<HealthCheckResult>> {
    public static final String ENDPOINT_ID = "camelhealthcheck";

    public CamelHealthCheckEndpoint(CamelContext camelContext) {
        super(ENDPOINT_ID, camelContext);
    }

    public Collection<HealthCheckResult> invoke() {
        return HealthCheckHelper.invoke((CamelContext)this.getCamelContext()).stream().map(result -> new HealthCheckResult((HealthCheck.Result)result, new Check((HealthCheck.Result)result))).collect(Collectors.toList());
    }

    Optional<HealthCheckResult> query(String id, Map<String, Object> options) {
        return HealthCheckHelper.query((CamelContext)this.getCamelContext(), (String)id, options).map(result -> new DetailedHealthCheckResult((HealthCheck.Result)result, new DetailedCheck((HealthCheck.Result)result)));
    }

    Optional<HealthCheckResult> invoke(String id, Map<String, Object> options) {
        return HealthCheckHelper.invoke((CamelContext)this.getCamelContext(), (String)id, options).map(result -> new DetailedHealthCheckResult((HealthCheck.Result)result, new DetailedCheck((HealthCheck.Result)result)));
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"status", "message", "details", "check"})
    public static class DetailedHealthCheckResult
    extends HealthCheckResult {
        public DetailedHealthCheckResult(HealthCheck.Result result, Check check) {
            super(result, check);
        }

        @JsonProperty(value="details")
        public Map<String, Object> getDetails() {
            return this.result.getDetails();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"id", "group", "metaData"})
    public static class DetailedCheck
    extends Check {
        private CheckConfiguration configuration;

        public DetailedCheck(HealthCheck.Result result) {
            super(result);
            this.configuration = new CheckConfiguration(result.getCheck().getConfiguration());
        }

        @JsonProperty(value="configuration")
        public CheckConfiguration getConfiguration() {
            return this.configuration;
        }

        @JsonProperty(value="metaData")
        public Map<String, Object> getMeta() {
            return this.result.getCheck().getMetaData();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"status", "message", "check"})
    public static class HealthCheckResult {
        protected final HealthCheck.Result result;
        protected final Check check;

        public HealthCheckResult(HealthCheck.Result result, Check check) {
            this.result = result;
            this.check = check;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.result.getState().name();
        }

        @JsonProperty(value="message")
        public String getMessage() {
            return this.result.getMessage().orElse(null);
        }

        @JsonProperty(value="check")
        public Check getCheck() {
            return this.check;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"id", "group"})
    public static class Check {
        protected final HealthCheck.Result result;

        public Check(HealthCheck.Result result) {
            this.result = result;
        }

        @JsonProperty(value="id")
        public String getId() {
            return this.result.getCheck().getId();
        }

        @JsonProperty(value="group")
        public String getGroup() {
            return this.result.getCheck().getGroup();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"enabled", "interval", "failureThreshold"})
    public static class CheckConfiguration {
        protected final HealthCheckConfiguration configuration;

        public CheckConfiguration(HealthCheckConfiguration configuration) {
            this.configuration = (HealthCheckConfiguration)ObjectHelper.supplyIfEmpty((Object)configuration, HealthCheckConfiguration::new);
        }

        @JsonProperty(value="enabled")
        public Boolean isEnabled() {
            return this.configuration.isEnabled();
        }

        @JsonProperty(value="interval")
        public String getDuration() {
            Duration interval = this.configuration.getInterval();
            return interval != null ? interval.toString() : null;
        }

        @JsonProperty(value="failureThreshold")
        public Integer getFailureThreshold() {
            return this.configuration.getFailureThreshold();
        }
    }
}

