/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ResponseStatus;

abstract class AbstractCamelMvcEndpoint<T extends Endpoint>
extends EndpointMvcAdapter {
    private static final ResponseEntity<Map<String, String>> FORBIDDEN_RESPONSE = new ResponseEntity(Collections.singletonMap("message", "This operation is forbidden"), HttpStatus.FORBIDDEN);
    private final T delegate;
    private boolean readOnly = true;

    protected AbstractCamelMvcEndpoint(String path, T delegate) {
        super(delegate);
        this.delegate = delegate;
        this.setPath(path);
    }

    protected ResponseEntity<?> getForbiddenResponse() {
        return FORBIDDEN_RESPONSE;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected T delegate() {
        return this.delegate;
    }

    protected Object doIfEnabled(Supplier<Object> supplier) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        return supplier.get();
    }

    protected Object doIfEnabled(Function<T, Object> supplier) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        return supplier.apply(this.delegate);
    }

    protected Object doIfEnabledAndNotReadOnly(Supplier<Object> supplier) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        if (this.isReadOnly()) {
            return this.getForbiddenResponse();
        }
        return supplier.get();
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public static class GenericException
    extends RuntimeException {
        public GenericException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

