/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.ha;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.impl.ha.ClusteredRouteConfiguration;
import org.apache.camel.impl.ha.ClusteredRouteController;
import org.apache.camel.impl.ha.ClusteredRouteFilter;
import org.apache.camel.impl.ha.ClusteredRouteFilters;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ha.ClusteredRouteControllerConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureBefore(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.clustered.controller", name={"enabled"})
@EnableConfigurationProperties(value={ClusteredRouteControllerConfiguration.class})
public class ClusteredRouteControllerAutoConfiguration {
    @Autowired(required=false)
    private List<ClusteredRouteFilter> filters = Collections.emptyList();

    @Bean
    @Scope(value="singleton")
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={CamelClusterService.class})
    public RouteController routeController(ClusteredRouteControllerConfiguration configuration) {
        ClusteredRouteController controller = new ClusteredRouteController();
        controller.setNamespace(configuration.getNamespace());
        Optional.ofNullable(configuration.getInitialDelay()).map(TimePatternConverter::toMilliSeconds).map(Duration::ofMillis).ifPresent(arg_0 -> ((ClusteredRouteController)controller).setInitialDelay(arg_0));
        controller.setFilters(this.filters);
        controller.addFilter((ClusteredRouteFilter)new ClusteredRouteFilters.IsAutoStartup());
        if (ObjectHelper.isNotEmpty((Object)configuration.getClusterService())) {
            controller.setClusterService(configuration.getClusterService());
        }
        for (Map.Entry<String, ClusteredRouteControllerConfiguration.RouteConfiguration> entry : configuration.getRoutes().entrySet()) {
            String routeId = entry.getKey();
            ClusteredRouteControllerConfiguration.RouteConfiguration conf = entry.getValue();
            if (conf.isClustered()) {
                ClusteredRouteConfiguration routeConfiguration = new ClusteredRouteConfiguration();
                routeConfiguration.setNamespace(Optional.ofNullable(conf.getNamespace()).orElseGet(() -> ((ClusteredRouteController)controller).getNamespace()));
                routeConfiguration.setInitialDelay(Optional.ofNullable(conf.getInitialDelay()).map(TimePatternConverter::toMilliSeconds).map(Duration::ofMillis).orElseGet(() -> ((ClusteredRouteController)controller).getInitialDelay()));
                controller.addRouteConfiguration(routeId, routeConfiguration);
                continue;
            }
            controller.addFilter((ClusteredRouteFilter)new ClusteredRouteFilters.BlackList(routeId));
        }
        return controller;
    }
}

