/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.camel.spring.boot.actuate.endpoint.AbstractCamelMvcEndpoint;
import org.apache.camel.spring.boot.actuate.endpoint.CamelRoutesEndpoint;
import org.apache.camel.spring.boot.model.RouteDetailsInfo;
import org.apache.camel.spring.boot.model.RouteInfo;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ConfigurationProperties(prefix="endpoints.camelroutes")
public class CamelRoutesMvcEndpoint
extends AbstractCamelMvcEndpoint<CamelRoutesEndpoint> {
    public CamelRoutesMvcEndpoint(CamelRoutesEndpoint delegate) {
        super("/camel/routes", delegate);
    }

    @ResponseBody
    @GetMapping(value={"/{id}/detail"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object detail(@PathVariable String id) {
        return this.doIfEnabled(() -> {
            RouteDetailsInfo result = ((CamelRoutesEndpoint)((Object)((Object)this.delegate()))).getRouteDetailsInfo(id);
            if (result == null) {
                throw new NoSuchRouteException("No such route " + id);
            }
            return result;
        });
    }

    @ResponseBody
    @GetMapping(value={"/{id}/info"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object info(@PathVariable String id) {
        return this.doIfEnabled(() -> {
            RouteInfo result = ((CamelRoutesEndpoint)((Object)((Object)this.delegate()))).getRouteInfo(id);
            if (result == null) {
                throw new NoSuchRouteException("No such route " + id);
            }
            return result;
        });
    }

    @ResponseBody
    @PostMapping(value={"/{id}/stop"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object stop(@PathVariable String id, @RequestAttribute(required=false) Long timeout, @RequestAttribute(required=false) Boolean abortAfterTimeout) {
        return this.doIfEnabled(() -> {
            try {
                ((CamelRoutesEndpoint)((Object)((Object)this.delegate()))).stopRoute(id, Optional.ofNullable(timeout), Optional.of(TimeUnit.SECONDS), Optional.ofNullable(abortAfterTimeout));
            }
            catch (Exception e) {
                throw new AbstractCamelMvcEndpoint.GenericException("Error stopping route " + id, e);
            }
            return ResponseEntity.ok().build();
        });
    }

    @ResponseBody
    @PostMapping(value={"/{id}/start"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object start(@PathVariable String id) {
        return this.doIfEnabled(() -> {
            try {
                ((CamelRoutesEndpoint)((Object)((Object)this.delegate()))).startRoute(id);
            }
            catch (Exception e) {
                throw new AbstractCamelMvcEndpoint.GenericException("Error starting route " + id, e);
            }
            return ResponseEntity.ok().build();
        });
    }

    @ResponseBody
    @PostMapping(value={"/{id}/reset"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object reset(@PathVariable String id) {
        return this.doIfEnabled(() -> {
            try {
                ((CamelRoutesEndpoint)((Object)((Object)this.delegate()))).resetRoute(id);
            }
            catch (Exception e) {
                throw new AbstractCamelMvcEndpoint.GenericException("Error resetting route stats " + id, e);
            }
            return ResponseEntity.ok().build();
        });
    }

    @ResponseBody
    @PostMapping(value={"/{id}/suspend"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object suspend(@PathVariable String id, @RequestAttribute(required=false) Long timeout) {
        return this.doIfEnabled(() -> {
            try {
                ((CamelRoutesEndpoint)((Object)((Object)this.delegate()))).suspendRoute(id, Optional.ofNullable(timeout), Optional.of(TimeUnit.SECONDS));
            }
            catch (Exception e) {
                throw new AbstractCamelMvcEndpoint.GenericException("Error suspending route " + id, e);
            }
            return ResponseEntity.ok().build();
        });
    }

    @ResponseBody
    @PostMapping(value={"/{id}/resume"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object resume(@PathVariable String id) {
        return this.doIfEnabled(() -> {
            try {
                ((CamelRoutesEndpoint)((Object)((Object)this.delegate()))).resumeRoute(id);
            }
            catch (Exception e) {
                throw new AbstractCamelMvcEndpoint.GenericException("Error resuming route " + id, e);
            }
            return ResponseEntity.ok().build();
        });
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such route")
    public static class NoSuchRouteException
    extends RuntimeException {
        public NoSuchRouteException(String message) {
            super(message);
        }
    }
}

