/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.boot.RoutesCollector;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.apache.camel.spring.boot.TypeConversionConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={CamelConfigurationProperties.class})
@Import(value={TypeConversionConfiguration.class})
public class CamelAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CamelContext.class})
    CamelContext camelContext(ApplicationContext applicationContext, CamelConfigurationProperties configurationProperties) {
        SpringCamelContext camelContext = new SpringCamelContext(applicationContext);
        SpringCamelContext.setNoStart((boolean)true);
        if (!configurationProperties.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (configurationProperties.getName() != null) {
            camelContext.setName(configurationProperties.getName());
        }
        return camelContext;
    }

    @Bean
    CamelSpringBootApplicationController applicationController(ApplicationContext applicationContext, CamelContext camelContext) {
        return new CamelSpringBootApplicationController(applicationContext, camelContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={RoutesCollector.class})
    RoutesCollector routesCollector(ApplicationContext applicationContext, CamelConfigurationProperties configurationProperties) {
        Collection configurations = applicationContext.getBeansOfType(CamelContextConfiguration.class).values();
        return new RoutesCollector(applicationContext, new ArrayList<CamelContextConfiguration>(configurations), configurationProperties);
    }

    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={ProducerTemplate.class})
    ProducerTemplate producerTemplate(CamelContext camelContext, CamelConfigurationProperties configurationProperties) {
        return camelContext.createProducerTemplate(configurationProperties.getProducerTemplateCacheSize());
    }

    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={ConsumerTemplate.class})
    ConsumerTemplate consumerTemplate(CamelContext camelContext, CamelConfigurationProperties configurationProperties) {
        return camelContext.createConsumerTemplate(configurationProperties.getConsumerTemplateCacheSize());
    }

    @Bean
    PropertiesParser propertiesParser() {
        return new SpringPropertiesParser();
    }

    @Bean(initMethod="", destroyMethod="")
    PropertiesComponent properties(CamelContext camelContext, PropertiesParser parser) {
        if (camelContext.hasComponent("properties") != null) {
            return (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
        }
        PropertiesComponent pc = new PropertiesComponent();
        pc.setPropertiesParser(parser);
        camelContext.addComponent("properties", (Component)pc);
        return pc;
    }

    @Bean
    CamelBeanPostProcessor camelBeanPostProcessor(ApplicationContext applicationContext) {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setApplicationContext(applicationContext);
        return processor;
    }
}

