/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.spring.boot.SpringTypeConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;

@Configuration
@ConditionalOnProperty(value={"camel.springboot.typeConversion"}, matchIfMissing=true)
public class TypeConversionConfiguration {
    @Bean
    TypeConverter typeConverter(CamelContext camelContext) {
        return camelContext.getTypeConverter();
    }

    @Bean
    SpringTypeConverter springTypeConverter(CamelContext camelContext, ConversionService[] conversionServices) {
        SpringTypeConverter springTypeConverter = new SpringTypeConverter(Arrays.asList(conversionServices));
        camelContext.getTypeConverterRegistry().addFallbackTypeConverter((TypeConverter)springTypeConverter, true);
        return springTypeConverter;
    }

    @ConditionalOnMissingBean
    @Bean
    ConversionService defaultCamelConversionService(ApplicationContext applicationContext) {
        DefaultConversionService service = new DefaultConversionService();
        for (Converter converter : applicationContext.getBeansOfType(Converter.class).values()) {
            service.addConverter(converter);
        }
        return service;
    }
}

