/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.UnsupportedEncodingException;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.impl.DefaultMessage;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.MessageRequest;

public class SmppMessage
extends DefaultMessage {
    private Command command;
    private SmppConfiguration configuration;

    public SmppMessage(SmppConfiguration configuration) {
        this.configuration = configuration;
    }

    public SmppMessage(AlertNotification command, SmppConfiguration configuration) {
        this.command = command;
        this.configuration = configuration;
    }

    public SmppMessage(DeliverSm command, SmppConfiguration configuration) {
        this.command = command;
        this.configuration = configuration;
    }

    public SmppMessage(DataSm dataSm, SmppConfiguration configuration) {
        this.command = dataSm;
        this.configuration = configuration;
    }

    public SmppMessage newInstance() {
        return new SmppMessage(this.configuration);
    }

    public boolean isAlertNotification() {
        return this.command instanceof AlertNotification;
    }

    public boolean isDataSm() {
        return this.command instanceof DataSm;
    }

    public boolean isDeliverSm() {
        return this.command instanceof DeliverSm && !((DeliverSm)this.command).isSmscDeliveryReceipt();
    }

    public boolean isDeliveryReceipt() {
        return this.command instanceof DeliverSm && ((DeliverSm)this.command).isSmscDeliveryReceipt();
    }

    protected Object createBody() {
        if (this.command instanceof MessageRequest) {
            byte[] shortMessage = ((MessageRequest)this.command).getShortMessage();
            try {
                return new String(shortMessage, this.configuration.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return new String(shortMessage);
            }
        }
        return null;
    }

    public String toString() {
        if (this.command != null) {
            return "SmppMessage: " + this.command;
        }
        return "SmppMessage: " + this.getBody();
    }

    public Command getCommand() {
        return this.command;
    }
}

