/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.session.connection.socket.SocketConnection;

public final class SmppSSLConnectionFactory
implements ConnectionFactory {
    private static final SmppSSLConnectionFactory CONN_FACTORY = new SmppSSLConnectionFactory();

    private SmppSSLConnectionFactory() {
    }

    public static SmppSSLConnectionFactory getInstance() {
        return CONN_FACTORY;
    }

    public Connection createConnection(String host, int port) throws IOException {
        try {
            SocketFactory socketFactory = SSLSocketFactory.getDefault();
            Socket socket = socketFactory.createSocket(host, port);
            return new SocketConnection(socket);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

