/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.component.smpp.SmppSSLConnectionFactory;
import org.apache.camel.impl.DefaultProducer;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.PDUComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SmppProducer.class);
    private SmppConfiguration configuration;
    private SMPPSession session;
    private SessionStateListener sessionStateListener;
    private final ReentrantLock reconnectLock = new ReentrantLock();

    public SmppProducer(SmppEndpoint endpoint, SmppConfiguration config) {
        super((Endpoint)endpoint);
        this.configuration = config;
        this.sessionStateListener = new SessionStateListener(){

            public void onStateChange(SessionState newState, SessionState oldState, Object source) {
                if (newState.equals((Object)SessionState.CLOSED)) {
                    LOG.warn("Loosing connection to: " + SmppProducer.this.getEndpoint().getConnectionString() + " - trying to reconnect...");
                    SmppProducer.this.closeSession(SmppProducer.this.session);
                    SmppProducer.this.reconnect(SmppProducer.this.configuration.getInitialReconnectDelay());
                }
            }
        };
    }

    protected void doStart() throws Exception {
        LOG.debug("Connecting to: " + this.getEndpoint().getConnectionString() + "...");
        super.doStart();
        this.session = this.createSession();
        LOG.info("Connected to: " + this.getEndpoint().getConnectionString());
    }

    private SMPPSession createSession() throws IOException {
        SMPPSession session = this.createSMPPSession();
        session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        session.addSessionStateListener(this.sessionStateListener);
        session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_TX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.valueOf((byte)this.configuration.getTypeOfNumber()), NumberingPlanIndicator.valueOf((byte)this.configuration.getNumberingPlanIndicator()), ""));
        return session;
    }

    SMPPSession createSMPPSession() {
        if (this.configuration.getUsingSSL()) {
            return new SMPPSession((PDUSender)new SynchronizedPDUSender((PDUSender)new DefaultPDUSender((PDUComposer)new DefaultComposer())), (PDUReader)new DefaultPDUReader(), (ConnectionFactory)SmppSSLConnectionFactory.getInstance());
        }
        return new SMPPSession();
    }

    public void process(Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending a short message for exchange id '" + exchange.getExchangeId() + "'...");
        }
        if (this.session == null) {
            throw new IOException("Lost connection to " + this.getEndpoint().getConnectionString() + " and yet not reconnected");
        }
        SubmitSm submitSm = this.getEndpoint().getBinding().createSubmitSm(exchange);
        String messageId = this.session.submitShortMessage(submitSm.getServiceType(), TypeOfNumber.valueOf((byte)submitSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)submitSm.getSourceAddrNpi()), submitSm.getSourceAddr(), TypeOfNumber.valueOf((byte)submitSm.getDestAddrTon()), NumberingPlanIndicator.valueOf((byte)submitSm.getDestAddrNpi()), submitSm.getDestAddress(), new ESMClass(), submitSm.getProtocolId(), submitSm.getPriorityFlag(), submitSm.getScheduleDeliveryTime(), submitSm.getValidityPeriod(), new RegisteredDelivery(submitSm.getRegisteredDelivery()), submitSm.getReplaceIfPresent(), (DataCoding)new GeneralDataCoding(false, true, MessageClass.CLASS1, Alphabet.valueOf((byte)submitSm.getDataCoding())), (byte)0, submitSm.getShortMessage(), new OptionalParameter[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent a short message for exchange id '" + exchange.getExchangeId() + "' and received message id '" + messageId + "'");
        }
        if (exchange.getPattern().isOutCapable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange is out capable, setting headers on out exchange...");
            }
            exchange.getOut().setHeader("CamelSmppId", (Object)messageId);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange is not out capable, setting headers on in exchange...");
            }
            exchange.getIn().setHeader("CamelSmppId", (Object)messageId);
        }
    }

    protected void doStop() throws Exception {
        LOG.debug("Disconnecting from: " + this.getEndpoint().getConnectionString() + "...");
        super.doStop();
        this.closeSession(this.session);
        LOG.info("Disconnected from: " + this.getEndpoint().getConnectionString());
    }

    private void closeSession(SMPPSession session) {
        if (session != null) {
            session.removeSessionStateListener(this.sessionStateListener);
            try {
                Thread.sleep(1000L);
                session.unbindAndClose();
            }
            catch (Exception e) {
                LOG.warn("Could not close session " + session);
            }
            session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(final long initialReconnectDelay) {
        if (this.reconnectLock.tryLock()) {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        boolean reconnected = false;
                        LOG.info("Schedule reconnect after " + initialReconnectDelay + " millis");
                        try {
                            Thread.sleep(initialReconnectDelay);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        int attempt = 0;
                        while (!(SmppProducer.this.isStopping() || SmppProducer.this.isStopped() || SmppProducer.this.session != null && !SmppProducer.this.session.getSessionState().equals((Object)SessionState.CLOSED))) {
                            try {
                                LOG.info("Trying to reconnect to " + SmppProducer.this.getEndpoint().getConnectionString() + " - attempt #" + ++attempt + "...");
                                SmppProducer.this.session = SmppProducer.this.createSession();
                                reconnected = true;
                            }
                            catch (IOException e) {
                                LOG.info("Failed to reconnect to " + SmppProducer.this.getEndpoint().getConnectionString());
                                SmppProducer.this.closeSession(SmppProducer.this.session);
                                try {
                                    Thread.sleep(SmppProducer.this.configuration.getReconnectDelay());
                                }
                                catch (InterruptedException ee) {}
                            }
                        }
                        if (reconnected) {
                            LOG.info("Reconnected to " + SmppProducer.this.getEndpoint().getConnectionString());
                        }
                    }
                };
                Thread t = new Thread(r);
                t.start();
                t.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.reconnectLock.unlock();
            }
        }
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "SmppProducer[" + this.getEndpoint().getConnectionString() + "]";
    }
}

