/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;

public class SmppProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(SmppProducer.class);
    private SmppConfiguration configuration;
    private SMPPSession session;

    public SmppProducer(SmppEndpoint endpoint, SmppConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to: " + this.getEndpoint().getConnectionString() + "..."));
        }
        super.doStart();
        this.session = this.createSMPPSession();
        this.session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        this.session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        this.session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_TX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.valueOf((byte)this.configuration.getTypeOfNumber()), NumberingPlanIndicator.valueOf((byte)this.configuration.getNumberingPlanIndicator()), ""));
        LOG.info((Object)("Connected to: " + this.getEndpoint().getConnectionString()));
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession();
    }

    public void process(Exchange exchange) throws Exception {
        String messageId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending a short message for exchange id '" + exchange.getExchangeId() + "'..."));
        }
        SubmitSm submitSm = this.getEndpoint().getBinding().createSubmitSm(exchange);
        try {
            messageId = this.doProcess(submitSm);
        }
        catch (Exception e) {
            this.doStop();
            this.doStart();
            messageId = this.doProcess(submitSm);
        }
        LOG.info((Object)("Sent a short message for exchange id '" + exchange.getExchangeId() + "' and received message id '" + messageId + "'"));
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setHeader("CamelSmppId", (Object)messageId);
        } else {
            exchange.getIn().setHeader("CamelSmppId", (Object)messageId);
        }
    }

    private String doProcess(SubmitSm submitSm) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        String messageId = this.session.submitShortMessage(submitSm.getServiceType(), TypeOfNumber.valueOf((byte)submitSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)submitSm.getSourceAddrNpi()), submitSm.getSourceAddr(), TypeOfNumber.valueOf((byte)submitSm.getDestAddrTon()), NumberingPlanIndicator.valueOf((byte)submitSm.getDestAddrNpi()), submitSm.getDestAddress(), new ESMClass(), submitSm.getProtocolId(), submitSm.getPriorityFlag(), submitSm.getScheduleDeliveryTime(), submitSm.getValidityPeriod(), new RegisteredDelivery(submitSm.getRegisteredDelivery()), submitSm.getReplaceIfPresent(), (DataCoding)new GeneralDataCoding(false, false, MessageClass.CLASS1, Alphabet.ALPHA_DEFAULT), (byte)0, submitSm.getShortMessage(), new OptionalParameter[0]);
        return messageId;
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Disconnecting from: " + this.getEndpoint().getConnectionString() + "..."));
        }
        super.doStop();
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        LOG.info((Object)("Disconnected from: " + this.getEndpoint().getConnectionString()));
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "SmppProducer[" + this.getEndpoint().getConnectionString() + "]";
    }
}

