/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;

public class SmppConsumer
extends DefaultConsumer {
    private static final transient Log LOG = LogFactory.getLog(SmppConsumer.class);
    private SmppConfiguration configuration;
    private SMPPSession session;

    public SmppConsumer(SmppEndpoint endpoint, SmppConfiguration configuration, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to: " + this.getEndpoint().getConnectionString() + "..."));
        }
        super.doStart();
        this.session = this.createSMPPSession();
        this.session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        this.session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        this.session.setMessageReceiverListener(new MessageReceiverListener(){

            public void onAcceptAlertNotification(AlertNotification alertNotification) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received an alertNotification " + alertNotification));
                }
                try {
                    Exchange exchange = SmppConsumer.this.getEndpoint().createOnAcceptAlertNotificationExchange(alertNotification);
                    LOG.trace((Object)"Processing the new smpp exchange...");
                    SmppConsumer.this.getProcessor().process(exchange);
                    LOG.trace((Object)"Processed the new smpp exchange");
                }
                catch (Exception e) {
                    SmppConsumer.this.getExceptionHandler().handleException((Throwable)e);
                }
            }

            public void onAcceptDeliverSm(DeliverSm deliverSm) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received a deliverSm " + deliverSm));
                }
                try {
                    Exchange exchange = SmppConsumer.this.getEndpoint().createOnAcceptDeliverSmExchange(deliverSm);
                    LOG.trace((Object)"processing the new smpp exchange...");
                    SmppConsumer.this.getProcessor().process(exchange);
                    LOG.trace((Object)"processed the new smpp exchange");
                }
                catch (Exception e) {
                    SmppConsumer.this.getExceptionHandler().handleException((Throwable)e);
                }
            }
        });
        this.session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_RX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, ""));
        LOG.info((Object)("Connected to: " + this.getEndpoint().getConnectionString()));
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession();
    }

    protected void doStop() throws Exception {
        LOG.debug((Object)("Disconnecting from: " + this.getEndpoint().getConnectionString() + "..."));
        super.doStop();
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        LOG.info((Object)("Disconnected from: " + this.getEndpoint().getConnectionString()));
    }

    public String toString() {
        return "SmppConsumer[" + this.getEndpoint().getConnectionString() + "]";
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }
}

